/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.config;

import java.io.Serializable;
import java.util.Map;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.IcebergCommonOptions;

public class IcebergCommonConfig
implements Serializable {
    private static final long serialVersionUID = 239821141534421580L;
    private String catalogName;
    private String namespace;
    private String table;
    private Map<String, String> catalogProps;
    private Map<String, String> hadoopProps;
    private String hadoopConfPath;
    private boolean caseSensitive;
    private String kerberosPrincipal;
    private String kerberosKeytabPath;
    private String kerberosKrb5ConfPath;

    public IcebergCommonConfig(ReadonlyConfig pluginConfig) {
        this.catalogName = (String)pluginConfig.get(IcebergCommonOptions.KEY_CATALOG_NAME);
        this.namespace = (String)pluginConfig.get(IcebergCommonOptions.KEY_NAMESPACE);
        this.table = (String)pluginConfig.get(IcebergCommonOptions.KEY_TABLE);
        this.catalogProps = (Map)pluginConfig.get(IcebergCommonOptions.CATALOG_PROPS);
        this.hadoopProps = (Map)pluginConfig.get(IcebergCommonOptions.HADOOP_PROPS);
        this.hadoopConfPath = (String)pluginConfig.get(IcebergCommonOptions.HADOOP_CONF_PATH_PROP);
        this.caseSensitive = (Boolean)pluginConfig.get(IcebergCommonOptions.KEY_CASE_SENSITIVE);
        if (pluginConfig.getOptional(IcebergCommonOptions.KERBEROS_PRINCIPAL).isPresent()) {
            this.kerberosPrincipal = (String)pluginConfig.get(IcebergCommonOptions.KERBEROS_PRINCIPAL);
        }
        if (pluginConfig.getOptional(IcebergCommonOptions.KRB5_PATH).isPresent()) {
            this.kerberosKrb5ConfPath = (String)pluginConfig.get(IcebergCommonOptions.KRB5_PATH);
        }
        if (pluginConfig.getOptional(IcebergCommonOptions.KERBEROS_KEYTAB_PATH).isPresent()) {
            this.kerberosKeytabPath = (String)pluginConfig.get(IcebergCommonOptions.KERBEROS_KEYTAB_PATH);
        }
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTable() {
        return this.table;
    }

    public Map<String, String> getCatalogProps() {
        return this.catalogProps;
    }

    public Map<String, String> getHadoopProps() {
        return this.hadoopProps;
    }

    public String getHadoopConfPath() {
        return this.hadoopConfPath;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public String getKerberosKeytabPath() {
        return this.kerberosKeytabPath;
    }

    public String getKerberosKrb5ConfPath() {
        return this.kerberosKrb5ConfPath;
    }

    public String toString() {
        return "IcebergCommonConfig(catalogName=" + this.getCatalogName() + ", namespace=" + this.getNamespace() + ", table=" + this.getTable() + ", catalogProps=" + this.getCatalogProps() + ", hadoopProps=" + this.getHadoopProps() + ", hadoopConfPath=" + this.getHadoopConfPath() + ", caseSensitive=" + this.isCaseSensitive() + ", kerberosPrincipal=" + this.getKerberosPrincipal() + ", kerberosKeytabPath=" + this.getKerberosKeytabPath() + ", kerberosKrb5ConfPath=" + this.getKerberosKrb5ConfPath() + ")";
    }
}

