/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.IcebergCommonConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.IcebergSinkOptions;
import org.apache.seatunnel.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.seatunnel.shade.com.google.common.collect.ImmutableList;

public class IcebergSinkConfig
extends IcebergCommonConfig {
    private static final long serialVersionUID = -2790210008337142246L;
    public static final int SCHEMA_UPDATE_RETRIES = 2;
    public static final int CREATE_TABLE_RETRIES = 2;
    private static final String ID_COLUMNS = "id-columns";
    private static final String PARTITION_BY = "partition-by";
    @VisibleForTesting
    private static final String COMMA_NO_PARENS_REGEX = ",(?![^()]*+\\))";
    private final ReadonlyConfig readonlyConfig;
    private Map<String, String> autoCreateProps;
    private Map<String, String> writeProps;
    private List<String> primaryKeys;
    private List<String> partitionKeys;
    private String commitBranch;
    private boolean upsertModeEnabled;
    private boolean tableSchemaEvolutionEnabled;
    private SchemaSaveMode schemaSaveMode;
    private DataSaveMode dataSaveMode;
    private String dataSaveModeSQL;

    public IcebergSinkConfig(ReadonlyConfig readonlyConfig) {
        super(readonlyConfig);
        this.readonlyConfig = readonlyConfig;
        this.autoCreateProps = (Map)readonlyConfig.get(IcebergSinkOptions.AUTO_CREATE_PROPS);
        this.writeProps = (Map)readonlyConfig.get(IcebergSinkOptions.WRITE_PROPS);
        this.primaryKeys = IcebergSinkConfig.stringToList((String)readonlyConfig.get(IcebergSinkOptions.TABLE_PRIMARY_KEYS), ",");
        this.partitionKeys = IcebergSinkConfig.stringToList((String)readonlyConfig.get(IcebergSinkOptions.TABLE_DEFAULT_PARTITION_KEYS), ",");
        this.upsertModeEnabled = (Boolean)readonlyConfig.get(IcebergSinkOptions.TABLE_UPSERT_MODE_ENABLED_PROP);
        this.tableSchemaEvolutionEnabled = (Boolean)readonlyConfig.get(IcebergSinkOptions.TABLE_SCHEMA_EVOLUTION_ENABLED_PROP);
        this.schemaSaveMode = (SchemaSaveMode)readonlyConfig.get(IcebergSinkOptions.SCHEMA_SAVE_MODE);
        this.dataSaveMode = (DataSaveMode)readonlyConfig.get(IcebergSinkOptions.DATA_SAVE_MODE);
        this.dataSaveModeSQL = (String)readonlyConfig.get(IcebergSinkOptions.DATA_SAVE_MODE_CUSTOM_SQL);
        this.commitBranch = (String)readonlyConfig.get(IcebergSinkOptions.TABLES_DEFAULT_COMMIT_BRANCH);
    }

    @VisibleForTesting
    public static List<String> stringToList(String value, String regex) {
        if (value == null || value.isEmpty()) {
            return ImmutableList.of();
        }
        return Arrays.stream(value.split(regex)).map(String::trim).collect(Collectors.toList());
    }

    public ReadonlyConfig getReadonlyConfig() {
        return this.readonlyConfig;
    }

    public Map<String, String> getAutoCreateProps() {
        return this.autoCreateProps;
    }

    public Map<String, String> getWriteProps() {
        return this.writeProps;
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public List<String> getPartitionKeys() {
        return this.partitionKeys;
    }

    public String getCommitBranch() {
        return this.commitBranch;
    }

    public boolean isUpsertModeEnabled() {
        return this.upsertModeEnabled;
    }

    public boolean isTableSchemaEvolutionEnabled() {
        return this.tableSchemaEvolutionEnabled;
    }

    public SchemaSaveMode getSchemaSaveMode() {
        return this.schemaSaveMode;
    }

    public DataSaveMode getDataSaveMode() {
        return this.dataSaveMode;
    }

    public String getDataSaveModeSQL() {
        return this.dataSaveModeSQL;
    }

    public void setAutoCreateProps(Map<String, String> autoCreateProps) {
        this.autoCreateProps = autoCreateProps;
    }

    public void setWriteProps(Map<String, String> writeProps) {
        this.writeProps = writeProps;
    }

    public void setPrimaryKeys(List<String> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public void setPartitionKeys(List<String> partitionKeys) {
        this.partitionKeys = partitionKeys;
    }

    public void setCommitBranch(String commitBranch) {
        this.commitBranch = commitBranch;
    }

    public void setUpsertModeEnabled(boolean upsertModeEnabled) {
        this.upsertModeEnabled = upsertModeEnabled;
    }

    public void setTableSchemaEvolutionEnabled(boolean tableSchemaEvolutionEnabled) {
        this.tableSchemaEvolutionEnabled = tableSchemaEvolutionEnabled;
    }

    public void setSchemaSaveMode(SchemaSaveMode schemaSaveMode) {
        this.schemaSaveMode = schemaSaveMode;
    }

    public void setDataSaveMode(DataSaveMode dataSaveMode) {
        this.dataSaveMode = dataSaveMode;
    }

    public void setDataSaveModeSQL(String dataSaveModeSQL) {
        this.dataSaveModeSQL = dataSaveModeSQL;
    }

    @Override
    public String toString() {
        return "IcebergSinkConfig(readonlyConfig=" + this.getReadonlyConfig() + ", autoCreateProps=" + this.getAutoCreateProps() + ", writeProps=" + this.getWriteProps() + ", primaryKeys=" + this.getPrimaryKeys() + ", partitionKeys=" + this.getPartitionKeys() + ", commitBranch=" + this.getCommitBranch() + ", upsertModeEnabled=" + this.isUpsertModeEnabled() + ", tableSchemaEvolutionEnabled=" + this.isTableSchemaEvolutionEnabled() + ", schemaSaveMode=" + this.getSchemaSaveMode() + ", dataSaveMode=" + this.getDataSaveMode() + ", dataSaveModeSQL=" + this.getDataSaveModeSQL() + ")";
    }
}

