/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.config;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.IcebergCommonConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.IcebergSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.SourceTableConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.scan.IcebergStreamScanStrategy;

public class IcebergSourceConfig
extends IcebergCommonConfig {
    private static final long serialVersionUID = -1965861967575264253L;
    private long incrementScanInterval;
    private List<SourceTableConfig> tableList;

    public IcebergSourceConfig(ReadonlyConfig readonlyConfig) {
        super(readonlyConfig);
        this.incrementScanInterval = (Long)readonlyConfig.get(IcebergSourceOptions.KEY_INCREMENT_SCAN_INTERVAL);
        if (this.getTable() != null) {
            SourceTableConfig tableConfig2 = SourceTableConfig.builder().namespace(this.getNamespace()).table(this.getTable()).startSnapshotTimestamp((Long)readonlyConfig.get(IcebergSourceOptions.KEY_START_SNAPSHOT_TIMESTAMP)).startSnapshotId((Long)readonlyConfig.get(IcebergSourceOptions.KEY_START_SNAPSHOT_ID)).endSnapshotId((Long)readonlyConfig.get(IcebergSourceOptions.KEY_END_SNAPSHOT_ID)).useSnapshotId((Long)readonlyConfig.get(IcebergSourceOptions.KEY_USE_SNAPSHOT_ID)).useSnapshotTimestamp((Long)readonlyConfig.get(IcebergSourceOptions.KEY_USE_SNAPSHOT_TIMESTAMP)).streamScanStrategy((IcebergStreamScanStrategy)((Object)readonlyConfig.get(IcebergSourceOptions.KEY_STREAM_SCAN_STRATEGY))).build();
            this.tableList = Collections.singletonList(tableConfig2);
        } else {
            this.tableList = ((List)readonlyConfig.get(IcebergSourceOptions.KEY_TABLE_LIST)).stream().map(tableConfig -> tableConfig.setNamespace(this.getNamespace())).collect(Collectors.toList());
        }
    }

    public SourceTableConfig getTableConfig(TablePath tablePath) {
        return this.tableList.stream().filter(tableConfig -> tableConfig.getTablePath().equals((Object)tablePath)).findFirst().get();
    }

    public long getIncrementScanInterval() {
        return this.incrementScanInterval;
    }

    public List<SourceTableConfig> getTableList() {
        return this.tableList;
    }

    @Override
    public String toString() {
        return "IcebergSourceConfig(incrementScanInterval=" + this.getIncrementScanInterval() + ", tableList=" + this.getTableList() + ")";
    }
}

