/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.config;

import java.io.Serializable;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.expressions.Expression;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.IcebergSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.scan.IcebergStreamScanStrategy;
import org.apache.seatunnel.connectors.seatunnel.iceberg.utils.SchemaUtils;

public class SourceTableConfig
implements Serializable {
    private String namespace;
    private String table;
    private Long startSnapshotTimestamp;
    private Long startSnapshotId;
    private Long endSnapshotId;
    private Long useSnapshotId;
    private Long useSnapshotTimestamp;
    private IcebergStreamScanStrategy streamScanStrategy = (IcebergStreamScanStrategy)((Object)IcebergSourceOptions.KEY_STREAM_SCAN_STRATEGY.defaultValue());
    private Expression filter;
    private Long splitSize;
    private Integer splitLookback;
    private Long splitOpenFileCost;

    public SourceTableConfig() {
    }

    public TablePath getTablePath() {
        String[] paths = this.table.split("\\.");
        if (paths.length == 1) {
            return TablePath.of((String)this.namespace, (String)this.table);
        }
        if (paths.length == 2) {
            return TablePath.of((String)paths[0], (String)paths[1]);
        }
        String namespace = this.table.substring(0, this.table.lastIndexOf("\\."));
        return TablePath.of((String)namespace, (String)this.table);
    }

    public TableIdentifier getTableIdentifier() {
        return SchemaUtils.toIcebergTableIdentifier(this.getTablePath());
    }

    public SourceTableConfig setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public static SourceTableConfigBuilder builder() {
        return new SourceTableConfigBuilder();
    }

    public SourceTableConfig(String namespace, String table, Long startSnapshotTimestamp, Long startSnapshotId, Long endSnapshotId, Long useSnapshotId, Long useSnapshotTimestamp, IcebergStreamScanStrategy streamScanStrategy, Expression filter, Long splitSize, Integer splitLookback, Long splitOpenFileCost) {
        this.namespace = namespace;
        this.table = table;
        this.startSnapshotTimestamp = startSnapshotTimestamp;
        this.startSnapshotId = startSnapshotId;
        this.endSnapshotId = endSnapshotId;
        this.useSnapshotId = useSnapshotId;
        this.useSnapshotTimestamp = useSnapshotTimestamp;
        this.streamScanStrategy = streamScanStrategy;
        this.filter = filter;
        this.splitSize = splitSize;
        this.splitLookback = splitLookback;
        this.splitOpenFileCost = splitOpenFileCost;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTable() {
        return this.table;
    }

    public Long getStartSnapshotTimestamp() {
        return this.startSnapshotTimestamp;
    }

    public Long getStartSnapshotId() {
        return this.startSnapshotId;
    }

    public Long getEndSnapshotId() {
        return this.endSnapshotId;
    }

    public Long getUseSnapshotId() {
        return this.useSnapshotId;
    }

    public Long getUseSnapshotTimestamp() {
        return this.useSnapshotTimestamp;
    }

    public IcebergStreamScanStrategy getStreamScanStrategy() {
        return this.streamScanStrategy;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public Long getSplitSize() {
        return this.splitSize;
    }

    public Integer getSplitLookback() {
        return this.splitLookback;
    }

    public Long getSplitOpenFileCost() {
        return this.splitOpenFileCost;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setStartSnapshotTimestamp(Long startSnapshotTimestamp) {
        this.startSnapshotTimestamp = startSnapshotTimestamp;
    }

    public void setStartSnapshotId(Long startSnapshotId) {
        this.startSnapshotId = startSnapshotId;
    }

    public void setEndSnapshotId(Long endSnapshotId) {
        this.endSnapshotId = endSnapshotId;
    }

    public void setUseSnapshotId(Long useSnapshotId) {
        this.useSnapshotId = useSnapshotId;
    }

    public void setUseSnapshotTimestamp(Long useSnapshotTimestamp) {
        this.useSnapshotTimestamp = useSnapshotTimestamp;
    }

    public void setStreamScanStrategy(IcebergStreamScanStrategy streamScanStrategy) {
        this.streamScanStrategy = streamScanStrategy;
    }

    public void setFilter(Expression filter) {
        this.filter = filter;
    }

    public void setSplitSize(Long splitSize) {
        this.splitSize = splitSize;
    }

    public void setSplitLookback(Integer splitLookback) {
        this.splitLookback = splitLookback;
    }

    public void setSplitOpenFileCost(Long splitOpenFileCost) {
        this.splitOpenFileCost = splitOpenFileCost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceTableConfig)) {
            return false;
        }
        SourceTableConfig other = (SourceTableConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$startSnapshotTimestamp = this.getStartSnapshotTimestamp();
        Long other$startSnapshotTimestamp = other.getStartSnapshotTimestamp();
        if (this$startSnapshotTimestamp == null ? other$startSnapshotTimestamp != null : !((Object)this$startSnapshotTimestamp).equals(other$startSnapshotTimestamp)) {
            return false;
        }
        Long this$startSnapshotId = this.getStartSnapshotId();
        Long other$startSnapshotId = other.getStartSnapshotId();
        if (this$startSnapshotId == null ? other$startSnapshotId != null : !((Object)this$startSnapshotId).equals(other$startSnapshotId)) {
            return false;
        }
        Long this$endSnapshotId = this.getEndSnapshotId();
        Long other$endSnapshotId = other.getEndSnapshotId();
        if (this$endSnapshotId == null ? other$endSnapshotId != null : !((Object)this$endSnapshotId).equals(other$endSnapshotId)) {
            return false;
        }
        Long this$useSnapshotId = this.getUseSnapshotId();
        Long other$useSnapshotId = other.getUseSnapshotId();
        if (this$useSnapshotId == null ? other$useSnapshotId != null : !((Object)this$useSnapshotId).equals(other$useSnapshotId)) {
            return false;
        }
        Long this$useSnapshotTimestamp = this.getUseSnapshotTimestamp();
        Long other$useSnapshotTimestamp = other.getUseSnapshotTimestamp();
        if (this$useSnapshotTimestamp == null ? other$useSnapshotTimestamp != null : !((Object)this$useSnapshotTimestamp).equals(other$useSnapshotTimestamp)) {
            return false;
        }
        Long this$splitSize = this.getSplitSize();
        Long other$splitSize = other.getSplitSize();
        if (this$splitSize == null ? other$splitSize != null : !((Object)this$splitSize).equals(other$splitSize)) {
            return false;
        }
        Integer this$splitLookback = this.getSplitLookback();
        Integer other$splitLookback = other.getSplitLookback();
        if (this$splitLookback == null ? other$splitLookback != null : !((Object)this$splitLookback).equals(other$splitLookback)) {
            return false;
        }
        Long this$splitOpenFileCost = this.getSplitOpenFileCost();
        Long other$splitOpenFileCost = other.getSplitOpenFileCost();
        if (this$splitOpenFileCost == null ? other$splitOpenFileCost != null : !((Object)this$splitOpenFileCost).equals(other$splitOpenFileCost)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        IcebergStreamScanStrategy this$streamScanStrategy = this.getStreamScanStrategy();
        IcebergStreamScanStrategy other$streamScanStrategy = other.getStreamScanStrategy();
        if (this$streamScanStrategy == null ? other$streamScanStrategy != null : !((Object)((Object)this$streamScanStrategy)).equals((Object)other$streamScanStrategy)) {
            return false;
        }
        Expression this$filter = this.getFilter();
        Expression other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !this$filter.equals(other$filter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SourceTableConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $startSnapshotTimestamp = this.getStartSnapshotTimestamp();
        result = result * 59 + ($startSnapshotTimestamp == null ? 43 : ((Object)$startSnapshotTimestamp).hashCode());
        Long $startSnapshotId = this.getStartSnapshotId();
        result = result * 59 + ($startSnapshotId == null ? 43 : ((Object)$startSnapshotId).hashCode());
        Long $endSnapshotId = this.getEndSnapshotId();
        result = result * 59 + ($endSnapshotId == null ? 43 : ((Object)$endSnapshotId).hashCode());
        Long $useSnapshotId = this.getUseSnapshotId();
        result = result * 59 + ($useSnapshotId == null ? 43 : ((Object)$useSnapshotId).hashCode());
        Long $useSnapshotTimestamp = this.getUseSnapshotTimestamp();
        result = result * 59 + ($useSnapshotTimestamp == null ? 43 : ((Object)$useSnapshotTimestamp).hashCode());
        Long $splitSize = this.getSplitSize();
        result = result * 59 + ($splitSize == null ? 43 : ((Object)$splitSize).hashCode());
        Integer $splitLookback = this.getSplitLookback();
        result = result * 59 + ($splitLookback == null ? 43 : ((Object)$splitLookback).hashCode());
        Long $splitOpenFileCost = this.getSplitOpenFileCost();
        result = result * 59 + ($splitOpenFileCost == null ? 43 : ((Object)$splitOpenFileCost).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        IcebergStreamScanStrategy $streamScanStrategy = this.getStreamScanStrategy();
        result = result * 59 + ($streamScanStrategy == null ? 43 : ((Object)((Object)$streamScanStrategy)).hashCode());
        Expression $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        return result;
    }

    public String toString() {
        return "SourceTableConfig(namespace=" + this.getNamespace() + ", table=" + this.getTable() + ", startSnapshotTimestamp=" + this.getStartSnapshotTimestamp() + ", startSnapshotId=" + this.getStartSnapshotId() + ", endSnapshotId=" + this.getEndSnapshotId() + ", useSnapshotId=" + this.getUseSnapshotId() + ", useSnapshotTimestamp=" + this.getUseSnapshotTimestamp() + ", streamScanStrategy=" + (Object)((Object)this.getStreamScanStrategy()) + ", filter=" + this.getFilter() + ", splitSize=" + this.getSplitSize() + ", splitLookback=" + this.getSplitLookback() + ", splitOpenFileCost=" + this.getSplitOpenFileCost() + ")";
    }

    public static class SourceTableConfigBuilder {
        private String namespace;
        private String table;
        private Long startSnapshotTimestamp;
        private Long startSnapshotId;
        private Long endSnapshotId;
        private Long useSnapshotId;
        private Long useSnapshotTimestamp;
        private IcebergStreamScanStrategy streamScanStrategy;
        private Expression filter;
        private Long splitSize;
        private Integer splitLookback;
        private Long splitOpenFileCost;

        SourceTableConfigBuilder() {
        }

        public SourceTableConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public SourceTableConfigBuilder table(String table) {
            this.table = table;
            return this;
        }

        public SourceTableConfigBuilder startSnapshotTimestamp(Long startSnapshotTimestamp) {
            this.startSnapshotTimestamp = startSnapshotTimestamp;
            return this;
        }

        public SourceTableConfigBuilder startSnapshotId(Long startSnapshotId) {
            this.startSnapshotId = startSnapshotId;
            return this;
        }

        public SourceTableConfigBuilder endSnapshotId(Long endSnapshotId) {
            this.endSnapshotId = endSnapshotId;
            return this;
        }

        public SourceTableConfigBuilder useSnapshotId(Long useSnapshotId) {
            this.useSnapshotId = useSnapshotId;
            return this;
        }

        public SourceTableConfigBuilder useSnapshotTimestamp(Long useSnapshotTimestamp) {
            this.useSnapshotTimestamp = useSnapshotTimestamp;
            return this;
        }

        public SourceTableConfigBuilder streamScanStrategy(IcebergStreamScanStrategy streamScanStrategy) {
            this.streamScanStrategy = streamScanStrategy;
            return this;
        }

        public SourceTableConfigBuilder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public SourceTableConfigBuilder splitSize(Long splitSize) {
            this.splitSize = splitSize;
            return this;
        }

        public SourceTableConfigBuilder splitLookback(Integer splitLookback) {
            this.splitLookback = splitLookback;
            return this;
        }

        public SourceTableConfigBuilder splitOpenFileCost(Long splitOpenFileCost) {
            this.splitOpenFileCost = splitOpenFileCost;
            return this;
        }

        public SourceTableConfig build() {
            return new SourceTableConfig(this.namespace, this.table, this.startSnapshotTimestamp, this.startSnapshotId, this.endSnapshotId, this.useSnapshotId, this.useSnapshotTimestamp, this.streamScanStrategy, this.filter, this.splitSize, this.splitLookback, this.splitOpenFileCost);
        }

        public String toString() {
            return "SourceTableConfig.SourceTableConfigBuilder(namespace=" + this.namespace + ", table=" + this.table + ", startSnapshotTimestamp=" + this.startSnapshotTimestamp + ", startSnapshotId=" + this.startSnapshotId + ", endSnapshotId=" + this.endSnapshotId + ", useSnapshotId=" + this.useSnapshotId + ", useSnapshotTimestamp=" + this.useSnapshotTimestamp + ", streamScanStrategy=" + (Object)((Object)this.streamScanStrategy) + ", filter=" + this.filter + ", splitSize=" + this.splitSize + ", splitLookback=" + this.splitLookback + ", splitOpenFileCost=" + this.splitOpenFileCost + ")";
        }
    }
}

