/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.sink.commit;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.seatunnel.connectors.seatunnel.iceberg.IcebergTableLoader;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.IcebergSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.writer.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergFilesCommitter
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(IcebergFilesCommitter.class);
    private IcebergTableLoader icebergTableLoader;
    private boolean caseSensitive;
    private String branch;

    private IcebergFilesCommitter(IcebergSinkConfig config, IcebergTableLoader icebergTableLoader) {
        this.icebergTableLoader = icebergTableLoader;
        this.caseSensitive = config.isCaseSensitive();
        this.branch = config.getCommitBranch();
    }

    public static IcebergFilesCommitter of(IcebergSinkConfig config, IcebergTableLoader icebergTableLoader) {
        return new IcebergFilesCommitter(config, icebergTableLoader);
    }

    public void doCommit(List<WriteResult> results) {
        TableIdentifier tableIdentifier = this.icebergTableLoader.getTableIdentifier();
        this.commit(tableIdentifier, results);
    }

    private void commit(TableIdentifier tableIdentifier, List<WriteResult> results) {
        List<DataFile> dataFiles = results.stream().filter(payload -> payload.getDataFiles() != null).flatMap(payload -> payload.getDataFiles().stream()).filter(dataFile -> dataFile.recordCount() > 0L).collect(Collectors.toList());
        List<DeleteFile> deleteFiles = results.stream().filter(payload -> payload.getDeleteFiles() != null).flatMap(payload -> payload.getDeleteFiles().stream()).filter(deleteFile -> deleteFile.recordCount() > 0L).collect(Collectors.toList());
        if (dataFiles.isEmpty() && deleteFiles.isEmpty()) {
            log.info(String.format("Nothing to commit to table %s, skipping", tableIdentifier));
        } else {
            Table table = this.icebergTableLoader.loadTable();
            log.info("do commit table : {}", (Object)table.toString());
            if (deleteFiles.isEmpty()) {
                AppendFiles append = table.newAppend();
                if (this.branch != null) {
                    append.toBranch(this.branch);
                }
                dataFiles.forEach(append::appendFile);
                append.commit();
            } else {
                RowDelta delta = table.newRowDelta();
                if (this.branch != null) {
                    delta.toBranch(this.branch);
                }
                delta.caseSensitive(this.caseSensitive);
                dataFiles.forEach(delta::addRows);
                deleteFiles.forEach(delta::addDeletes);
                delta.commit();
            }
        }
    }
}

