/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.connectors.seatunnel.iceberg.IcebergCatalogLoader;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.IcebergSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.IcebergBatchSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.IcebergSplitEnumeratorState;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.IcebergStreamSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.reader.IcebergSourceReader;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.split.IcebergFileScanTaskSplit;

public class IcebergSource
implements SeaTunnelSource<SeaTunnelRow, IcebergFileScanTaskSplit, IcebergSplitEnumeratorState>,
SupportParallelism,
SupportColumnProjection {
    private static final long serialVersionUID = 4343414808223919870L;
    private final IcebergSourceConfig sourceConfig;
    private final Map<TablePath, CatalogTable> catalogTables;
    private final Map<TablePath, Pair<Schema, Schema>> tableSchemaProjections;
    private JobContext jobContext;

    public IcebergSource(IcebergSourceConfig config, List<CatalogTable> catalogTables) {
        this.sourceConfig = config;
        this.catalogTables = catalogTables.stream().collect(Collectors.toMap(CatalogTable::getTablePath, table -> table));
        this.tableSchemaProjections = this.loadIcebergSchemaProjections(config, this.catalogTables);
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return new ArrayList<CatalogTable>(this.catalogTables.values());
    }

    public String getPluginName() {
        return "Iceberg";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<TablePath, Pair<Schema, Schema>> loadIcebergSchemaProjections(IcebergSourceConfig config, Map<TablePath, CatalogTable> tables) {
        IcebergCatalogLoader catalogFactory = new IcebergCatalogLoader(config);
        Catalog catalog = catalogFactory.loadCatalog();
        HashMap<TablePath, Pair<Schema, Schema>> icebergTables = new HashMap<TablePath, Pair<Schema, Schema>>();
        try {
            for (TablePath tablePath : tables.keySet()) {
                CatalogTable catalogTable = tables.get(tablePath);
                Table icebergTable = catalog.loadTable(TableIdentifier.of(tablePath.getDatabaseName(), tablePath.getTableName()));
                Schema icebergSchema = icebergTable.schema();
                Schema projectedSchema = icebergSchema.select(catalogTable.getTableSchema().getFieldNames());
                icebergTables.put(tablePath, Pair.of(icebergSchema, projectedSchema));
            }
        }
        finally {
            if (catalog instanceof AutoCloseable) {
                ((AutoCloseable)((Object)catalog)).close();
            }
        }
        return icebergTables;
    }

    public Boundedness getBoundedness() {
        return JobMode.BATCH.equals((Object)this.jobContext.getJobMode()) ? Boundedness.BOUNDED : Boundedness.UNBOUNDED;
    }

    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    public SourceReader<SeaTunnelRow, IcebergFileScanTaskSplit> createReader(SourceReader.Context readerContext) {
        return new IcebergSourceReader(readerContext, this.sourceConfig, this.catalogTables, this.tableSchemaProjections);
    }

    public SourceSplitEnumerator<IcebergFileScanTaskSplit, IcebergSplitEnumeratorState> createEnumerator(SourceSplitEnumerator.Context<IcebergFileScanTaskSplit> enumeratorContext) {
        if (Boundedness.BOUNDED.equals((Object)this.getBoundedness())) {
            return new IcebergBatchSplitEnumerator(enumeratorContext, this.sourceConfig, this.catalogTables, this.tableSchemaProjections);
        }
        return new IcebergStreamSplitEnumerator(enumeratorContext, this.sourceConfig, this.catalogTables, this.tableSchemaProjections);
    }

    public SourceSplitEnumerator<IcebergFileScanTaskSplit, IcebergSplitEnumeratorState> restoreEnumerator(SourceSplitEnumerator.Context<IcebergFileScanTaskSplit> enumeratorContext, IcebergSplitEnumeratorState checkpointState) {
        if (Boundedness.BOUNDED.equals((Object)this.getBoundedness())) {
            return new IcebergBatchSplitEnumerator(enumeratorContext, this.sourceConfig, this.catalogTables, this.tableSchemaProjections, checkpointState);
        }
        return new IcebergStreamSplitEnumerator(enumeratorContext, this.sourceConfig, this.catalogTables, this.tableSchemaProjections, checkpointState);
    }
}

