/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.ConnectorCommonOptions;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.iceberg.catalog.IcebergCatalog;
import org.apache.seatunnel.connectors.seatunnel.iceberg.catalog.IcebergCatalogFactory;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.IcebergCommonOptions;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.IcebergSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.IcebergSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.IcebergSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Factory.class})
public class IcebergSourceFactory
implements TableSourceFactory {
    private static final Logger log = LoggerFactory.getLogger(IcebergSourceFactory.class);

    public String factoryIdentifier() {
        return "Iceberg";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{IcebergCommonOptions.KEY_CATALOG_NAME, IcebergCommonOptions.KEY_NAMESPACE, IcebergCommonOptions.CATALOG_PROPS}).exclusive(new Option[]{IcebergCommonOptions.KEY_TABLE, IcebergSourceOptions.KEY_TABLE_LIST}).optional(new Option[]{ConnectorCommonOptions.SCHEMA, IcebergSourceOptions.KEY_CASE_SENSITIVE, IcebergSourceOptions.KEY_START_SNAPSHOT_TIMESTAMP, IcebergSourceOptions.KEY_START_SNAPSHOT_ID, IcebergSourceOptions.KEY_END_SNAPSHOT_ID, IcebergSourceOptions.KEY_USE_SNAPSHOT_ID, IcebergSourceOptions.KEY_USE_SNAPSHOT_TIMESTAMP, IcebergSourceOptions.KEY_STREAM_SCAN_STRATEGY, IcebergSourceOptions.KEY_INCREMENT_SCAN_INTERVAL, IcebergCommonOptions.HADOOP_PROPS, IcebergSourceOptions.HADOOP_CONF_PATH_PROP, IcebergCommonOptions.KERBEROS_PRINCIPAL, IcebergCommonOptions.KERBEROS_KEYTAB_PATH, IcebergCommonOptions.KRB5_PATH}).build();
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        ReadonlyConfig options = context.getOptions();
        IcebergSourceConfig config = new IcebergSourceConfig(options);
        if (options.get(ConnectorCommonOptions.SCHEMA) != null) {
            TablePath tablePath = config.getTableList().get(0).getTablePath();
            CatalogTable catalogTable = CatalogTableUtil.buildWithConfig((String)this.factoryIdentifier(), (ReadonlyConfig)options);
            TableIdentifier tableIdentifier = TableIdentifier.of((String)catalogTable.getCatalogName(), (TablePath)tablePath);
            CatalogTable table = CatalogTable.of((TableIdentifier)tableIdentifier, (CatalogTable)catalogTable);
            return () -> new IcebergSource(config, Collections.singletonList(table));
        }
        try (IcebergCatalog catalog = (IcebergCatalog)new IcebergCatalogFactory().createCatalog(this.factoryIdentifier(), options);){
            catalog.open();
            if (config.getTable() != null) {
                TablePath tablePath = config.getTableList().get(0).getTablePath();
                CatalogTable catalogTable = catalog.getTable(tablePath);
                TableSource tableSource = () -> new IcebergSource(config, Collections.singletonList(catalogTable));
                return tableSource;
            }
            List catalogTables = config.getTableList().stream().map(tableConfig -> catalog.getTable(tableConfig.getTablePath())).collect(Collectors.toList());
            TableSource tableSource = () -> new IcebergSource(config, catalogTables);
            return tableSource;
        }
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return IcebergSource.class;
    }
}

