/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.IcebergSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.AbstractSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.IcebergSplitEnumeratorState;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.scan.IcebergScanContext;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.scan.IcebergScanSplitPlanner;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.split.IcebergFileScanTaskSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergBatchSplitEnumerator
extends AbstractSplitEnumerator {
    private static final Logger log = LoggerFactory.getLogger(IcebergBatchSplitEnumerator.class);

    public IcebergBatchSplitEnumerator(SourceSplitEnumerator.Context<IcebergFileScanTaskSplit> context, IcebergSourceConfig sourceConfig, Map<TablePath, CatalogTable> catalogTables, Map<TablePath, Pair<Schema, Schema>> tableSchemaProjections) {
        this(context, sourceConfig, catalogTables, tableSchemaProjections, null);
    }

    public IcebergBatchSplitEnumerator(SourceSplitEnumerator.Context<IcebergFileScanTaskSplit> context, IcebergSourceConfig sourceConfig, Map<TablePath, CatalogTable> catalogTables, Map<TablePath, Pair<Schema, Schema>> tableSchemaProjections, IcebergSplitEnumeratorState state) {
        super(context, sourceConfig, catalogTables, tableSchemaProjections, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Set readers = this.context.registeredReaders();
        while (!this.pendingTables.isEmpty()) {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkThrowInterruptedException();
                TablePath tablePath = (TablePath)this.pendingTables.poll();
                log.info("Splitting table {}.", (Object)tablePath);
                List<IcebergFileScanTaskSplit> splits = this.loadSplits(tablePath);
                log.info("Split table {} into {} splits.", (Object)tablePath, (Object)splits.size());
                this.addPendingSplits(splits);
            }
            object = this.stateLock;
            synchronized (object) {
                this.assignPendingSplits(readers);
            }
        }
        log.debug("No more splits to assign. Sending NoMoreSplitsEvent to reader {}.", (Object)readers);
        readers.forEach(arg_0 -> ((SourceSplitEnumerator.Context)this.context).signalNoMoreSplits(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcebergSplitEnumeratorState snapshotState(long checkpointId) throws Exception {
        Object object = this.stateLock;
        synchronized (object) {
            return new IcebergSplitEnumeratorState(new ArrayList<TablePath>(this.pendingTables), new HashMap<Integer, List<IcebergFileScanTaskSplit>>(this.pendingSplits));
        }
    }

    private List<IcebergFileScanTaskSplit> loadSplits(TablePath tablePath) {
        Table table = this.loadTable(tablePath);
        Pair tableSchemaProjection = (Pair)this.tableSchemaProjections.get(tablePath);
        IcebergScanContext scanContext = IcebergScanContext.scanContext(this.sourceConfig, this.sourceConfig.getTableConfig(tablePath), (Schema)tableSchemaProjection.getRight());
        return IcebergScanSplitPlanner.planSplits(table, scanContext);
    }
}

