/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.source.split;

import java.util.HashMap;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.TablePath;

public class IcebergFileScanTaskSplit
implements SourceSplit {
    private static final long serialVersionUID = -9043797960947110643L;
    private final TablePath tablePath;
    private final FileScanTask task;
    private volatile long recordOffset;

    public IcebergFileScanTaskSplit(TablePath tablePath, @NonNull FileScanTask task) {
        this(tablePath, task, 0L);
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
    }

    @Deprecated
    public IcebergFileScanTaskSplit(@NonNull FileScanTask task) {
        this(null, task, 0L);
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
    }

    public String splitId() {
        return ((DataFile)this.task.file()).path().toString();
    }

    public String toString() {
        return "IcebergFileScanTaskSplit{task=" + this.toString(this.task) + ", recordOffset=" + this.recordOffset + '}';
    }

    private String toString(FileScanTask task) {
        HashMap<String, Object> taskInfo = new HashMap<String, Object>();
        taskInfo.put("file", ((DataFile)task.file()).path().toString());
        taskInfo.put("start", task.start());
        taskInfo.put("length", task.length());
        taskInfo.put("deletes", task.deletes().stream().map(deleteFile -> deleteFile.path()).collect(Collectors.toList()));
        return ((Object)taskInfo).toString();
    }

    public TablePath getTablePath() {
        return this.tablePath;
    }

    public FileScanTask getTask() {
        return this.task;
    }

    public long getRecordOffset() {
        return this.recordOffset;
    }

    public IcebergFileScanTaskSplit(TablePath tablePath, FileScanTask task, long recordOffset) {
        this.tablePath = tablePath;
        this.task = task;
        this.recordOffset = recordOffset;
    }

    public void setRecordOffset(long recordOffset) {
        this.recordOffset = recordOffset;
    }
}

