/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression;

import java.util.List;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.AnalyticType;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.Expression;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.OrderByClause;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.PartitionByClause;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.WindowElement;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.OrderByElement;

public class FilterOverImpl
extends ASTNodeAccessImpl {
    private final OrderByClause orderBy = new OrderByClause();
    private final PartitionByClause partitionBy = new PartitionByClause();
    private AnalyticType analyticType = AnalyticType.FILTER_ONLY;
    private Expression filterExpression = null;
    private WindowElement windowElement = null;

    public AnalyticType getAnalyticType() {
        return this.analyticType;
    }

    public void setAnalyticType(AnalyticType analyticType) {
        this.analyticType = analyticType;
    }

    public FilterOverImpl withAnalyticType(AnalyticType analyticType) {
        this.setAnalyticType(analyticType);
        return this;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderBy.getOrderByElements();
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderBy.setOrderByElements(orderByElements);
    }

    public FilterOverImpl withOrderByElements(List<OrderByElement> orderByElements) {
        this.setOrderByElements(orderByElements);
        return this;
    }

    public ExpressionList getPartitionExpressionList() {
        return this.partitionBy.getPartitionExpressionList();
    }

    public void setPartitionExpressionList(ExpressionList partitionExpressionList) {
        this.setPartitionExpressionList(partitionExpressionList, false);
    }

    public void setPartitionExpressionList(ExpressionList partitionExpressionList, boolean brackets) {
        this.partitionBy.setPartitionExpressionList(partitionExpressionList, brackets);
    }

    public boolean isPartitionByBrackets() {
        return this.partitionBy.isBrackets();
    }

    public Expression getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(Expression filterExpression) {
        this.filterExpression = filterExpression;
    }

    public FilterOverImpl withFilterExpression(Expression filterExpression) {
        this.setFilterExpression(filterExpression);
        return this;
    }

    public WindowElement getWindowElement() {
        return this.windowElement;
    }

    public void setWindowElement(WindowElement windowElement) {
        this.windowElement = windowElement;
    }

    public FilterOverImpl withWindowElement(WindowElement windowElement) {
        this.setWindowElement(windowElement);
        return this;
    }

    public StringBuilder append(StringBuilder builder) {
        if (this.filterExpression != null) {
            builder.append("FILTER (WHERE ");
            builder.append(this.filterExpression.toString());
            builder.append(")");
            if (this.analyticType != AnalyticType.FILTER_ONLY) {
                builder.append(" ");
            }
        }
        switch (this.analyticType) {
            case FILTER_ONLY: {
                return builder;
            }
            case WITHIN_GROUP: {
                builder.append("WITHIN GROUP");
                break;
            }
            default: {
                builder.append("OVER");
            }
        }
        builder.append(" (");
        this.partitionBy.toStringPartitionBy(builder);
        this.orderBy.toStringOrderByElements(builder);
        if (this.windowElement != null) {
            if (this.orderBy.getOrderByElements() != null) {
                builder.append(' ');
            }
            builder.append(this.windowElement);
        }
        builder.append(")");
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        return this.append(builder).toString();
    }
}

