/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.parser.feature;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.parser.feature.Feature;

public class FeatureConfiguration {
    private static final Logger LOG = Logger.getLogger(FeatureConfiguration.class.getName());
    private Map<Feature, Object> featureEnabled = new EnumMap<Feature, Object>(Feature.class);

    public FeatureConfiguration() {
        EnumSet.allOf(Feature.class).stream().filter(Feature::isConfigurable).forEach(f -> this.setValue((Feature)((Object)f), f.getDefaultValue()));
    }

    public FeatureConfiguration setValue(Feature feature, Object value) {
        if (feature.isConfigurable()) {
            this.featureEnabled.put(feature, value);
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning(feature.name() + " is not switchable - cannot set enabled = " + value);
        }
        return this;
    }

    public Object getValue(Feature feature) {
        if (feature.isConfigurable()) {
            return this.featureEnabled.get((Object)feature);
        }
        throw new IllegalStateException("The feature " + (Object)((Object)feature) + " is not configurable!");
    }

    public boolean getAsBoolean(Feature f) {
        return Boolean.parseBoolean(String.valueOf(this.getValue(f)));
    }

    public Long getAsLong(Feature f) {
        return Long.valueOf(String.valueOf(this.getValue(f)));
    }

    public String getAsString(Feature f) {
        Object value = this.getValue(f);
        return value == null ? null : String.valueOf(value);
    }
}

