/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.delete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.Expression;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.OracleHint;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.schema.Table;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.OutputClause;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.ReturningClause;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.Statement;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.StatementVisitor;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.delete.DeleteModifierPriority;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.Join;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.Limit;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.OrderByElement;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.PlainSelect;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.WithItem;

public class Delete
implements Statement {
    private List<WithItem> withItemsList;
    private Table table;
    private OracleHint oracleHint = null;
    private List<Table> tables;
    private List<Table> usingList;
    private List<Join> joins;
    private Expression where;
    private Limit limit;
    private List<OrderByElement> orderByElements;
    private boolean hasFrom = true;
    private DeleteModifierPriority modifierPriority;
    private boolean modifierIgnore;
    private boolean modifierQuick;
    private ReturningClause returningClause;
    private OutputClause outputClause;

    public OutputClause getOutputClause() {
        return this.outputClause;
    }

    public void setOutputClause(OutputClause outputClause) {
        this.outputClause = outputClause;
    }

    public ReturningClause getReturningClause() {
        return this.returningClause;
    }

    public Delete setReturningClause(ReturningClause returningClause) {
        this.returningClause = returningClause;
        return this;
    }

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> withItemsList) {
        this.withItemsList = withItemsList;
    }

    public Delete withWithItemsList(List<WithItem> withItemsList) {
        this.setWithItemsList(withItemsList);
        return this;
    }

    public Delete addWithItemsList(WithItem ... withItemsList) {
        List collection = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, withItemsList);
        return this.withWithItemsList(collection);
    }

    public Delete addWithItemsList(Collection<? extends WithItem> withItemsList) {
        List collection = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        collection.addAll(withItemsList);
        return this.withWithItemsList(collection);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public void setTables(List<Table> tables) {
        this.tables = tables;
    }

    public List<Table> getUsingList() {
        return this.usingList;
    }

    public void setUsingList(List<Table> usingList) {
        this.usingList = usingList;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> joins) {
        this.joins = joins;
    }

    public boolean isHasFrom() {
        return this.hasFrom;
    }

    public void setHasFrom(boolean hasFrom) {
        this.hasFrom = hasFrom;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            b.append("WITH ");
            Iterator<WithItem> iter = this.withItemsList.iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                b.append(withItem);
                if (iter.hasNext()) {
                    b.append(",");
                }
                b.append(" ");
            }
        }
        b.append("DELETE");
        if (this.oracleHint != null) {
            b.append(this.oracleHint).append(" ");
        }
        if (this.modifierPriority != null) {
            b.append(" ").append(this.modifierPriority.name());
        }
        if (this.modifierQuick) {
            b.append(" QUICK");
        }
        if (this.modifierIgnore) {
            b.append(" IGNORE");
        }
        if (this.tables != null && this.tables.size() > 0) {
            b.append(" ");
            b.append(this.tables.stream().map(Table::toString).collect(Collectors.joining(", ")));
        }
        if (this.outputClause != null) {
            this.outputClause.appendTo(b);
        }
        if (this.hasFrom) {
            b.append(" FROM");
        }
        b.append(" ").append(this.table);
        if (this.usingList != null && this.usingList.size() > 0) {
            b.append(" USING ");
            b.append(this.usingList.stream().map(Table::toString).collect(Collectors.joining(", ")));
        }
        if (this.joins != null) {
            for (Join join : this.joins) {
                if (join.isSimple()) {
                    b.append(", ").append(join);
                    continue;
                }
                b.append(" ").append(join);
            }
        }
        if (this.where != null) {
            b.append(" WHERE ").append(this.where);
        }
        if (this.orderByElements != null) {
            b.append(PlainSelect.orderByToString(this.orderByElements));
        }
        if (this.limit != null) {
            b.append(this.limit);
        }
        if (this.returningClause != null) {
            this.returningClause.appendTo(b);
        }
        return b.toString();
    }

    public Delete withTables(List<Table> tables) {
        this.setTables(tables);
        return this;
    }

    public Delete withUsingList(List<Table> usingList) {
        this.setUsingList(usingList);
        return this;
    }

    public Delete withJoins(List<Join> joins) {
        this.setJoins(joins);
        return this;
    }

    public Delete withLimit(Limit limit) {
        this.setLimit(limit);
        return this;
    }

    public Delete withOrderByElements(List<OrderByElement> orderByElements) {
        this.setOrderByElements(orderByElements);
        return this;
    }

    public Delete withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Delete withWhere(Expression where) {
        this.setWhere(where);
        return this;
    }

    public Delete withHasFrom(boolean hasFrom) {
        this.setHasFrom(hasFrom);
        return this;
    }

    public Delete withModifierPriority(DeleteModifierPriority modifierPriority) {
        this.setModifierPriority(modifierPriority);
        return this;
    }

    public Delete withModifierIgnore(boolean modifierIgnore) {
        this.setModifierIgnore(modifierIgnore);
        return this;
    }

    public Delete withModifierQuick(boolean modifierQuick) {
        this.setModifierQuick(modifierQuick);
        return this;
    }

    public void setModifierPriority(DeleteModifierPriority modifierPriority) {
        this.modifierPriority = modifierPriority;
    }

    public DeleteModifierPriority getModifierPriority() {
        return this.modifierPriority;
    }

    public void setModifierIgnore(boolean modifierIgnore) {
        this.modifierIgnore = modifierIgnore;
    }

    public void setModifierQuick(boolean modifierQuick) {
        this.modifierQuick = modifierQuick;
    }

    public boolean isModifierIgnore() {
        return this.modifierIgnore;
    }

    public boolean isModifierQuick() {
        return this.modifierQuick;
    }

    public Delete addTables(Table ... tables) {
        List collection = Optional.ofNullable(this.getTables()).orElseGet(ArrayList::new);
        Collections.addAll(collection, tables);
        return this.withTables(collection);
    }

    public Delete addTables(Collection<? extends Table> tables) {
        List collection = Optional.ofNullable(this.getTables()).orElseGet(ArrayList::new);
        collection.addAll(tables);
        return this.withTables(collection);
    }

    public Delete addUsingList(Table ... usingList) {
        List collection = Optional.ofNullable(this.getUsingList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, usingList);
        return this.withUsingList(collection);
    }

    public Delete addUsingList(Collection<? extends Table> usingList) {
        List collection = Optional.ofNullable(this.getUsingList()).orElseGet(ArrayList::new);
        collection.addAll(usingList);
        return this.withUsingList(collection);
    }

    public Delete addJoins(Join ... joins) {
        List collection = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        Collections.addAll(collection, joins);
        return this.withJoins(collection);
    }

    public Delete addJoins(Collection<? extends Join> joins) {
        List collection = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        collection.addAll(joins);
        return this.withJoins(collection);
    }

    public Delete addOrderByElements(OrderByElement ... orderByElements) {
        List collection = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        Collections.addAll(collection, orderByElements);
        return this.withOrderByElements(collection);
    }

    public Delete addOrderByElements(Collection<? extends OrderByElement> orderByElements) {
        List collection = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        collection.addAll(orderByElements);
        return this.withOrderByElements(collection);
    }

    public <E extends Expression> E getWhere(Class<E> type) {
        return (E)((Expression)type.cast(this.getWhere()));
    }
}

