/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.Alias;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.FromItem;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.FromItemVisitor;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.Join;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.Pivot;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.UnPivot;

public class ParenthesedFromItem
implements FromItem {
    private FromItem fromItem;
    private List<Join> joins;
    private Alias alias;
    private Pivot pivot;
    private UnPivot unPivot;

    public ParenthesedFromItem() {
    }

    public ParenthesedFromItem(FromItem fromItem) {
        this.setFromItem(fromItem);
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public final void setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public Join getJoin(int index) {
        return this.joins.get(index);
    }

    public FromItem addJoins(Join ... joins) {
        List list = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        Collections.addAll(list, joins);
        return this.withJoins(list);
    }

    public FromItem withJoins(List<Join> joins) {
        this.setJoins(joins);
        return this;
    }

    public void setJoins(List<Join> list) {
        this.joins = list;
    }

    @Override
    public void accept(FromItemVisitor fromItemVisitor) {
        fromItemVisitor.visit(this);
    }

    public StringBuilder appendTo(StringBuilder builder) {
        builder.append("(");
        builder.append(this.fromItem);
        if (this.joins != null) {
            for (Join join : this.joins) {
                if (join.isSimple()) {
                    builder.append(", ").append(join);
                    continue;
                }
                builder.append(" ").append(join);
            }
        }
        builder.append(")");
        if (this.alias != null) {
            builder.append(this.alias);
        }
        if (this.pivot != null) {
            builder.append(this.pivot);
        }
        if (this.unPivot != null) {
            builder.append(this.unPivot);
        }
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    @Override
    public Pivot getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(Pivot pivot) {
        this.pivot = pivot;
    }

    @Override
    public UnPivot getUnPivot() {
        return this.unPivot;
    }

    @Override
    public void setUnPivot(UnPivot unpivot) {
        this.unPivot = unpivot;
    }

    public ParenthesedFromItem withFromItem(FromItem fromItem) {
        this.setFromItem(fromItem);
        return this;
    }

    @Override
    public ParenthesedFromItem withAlias(Alias alias) {
        this.setAlias(alias);
        return this;
    }

    public <E extends FromItem> E getFromItem(Class<E> type) {
        return (E)((FromItem)type.cast(this.getFromItem()));
    }
}

