/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.OrderByElement;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.PlainSelect;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.Select;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.SelectVisitor;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.SetOperation;

public class SetOperationList
extends Select {
    private List<Select> selects;
    private List<SetOperation> operations;
    private List<OrderByElement> orderByElements;

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    @Override
    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public List<Select> getSelects() {
        return this.selects;
    }

    public Select getSelect(int index) {
        return this.selects.get(index);
    }

    public void setSelects(List<Select> selects) {
        this.selects = selects;
    }

    public void setOperations(List<SetOperation> operations) {
        this.operations = operations;
    }

    public List<SetOperation> getOperations() {
        return this.operations;
    }

    public SetOperation getOperation(int index) {
        return this.operations.get(index);
    }

    @Override
    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public void setBracketsOpsAndSelects(List<Select> select, List<SetOperation> ops) {
        this.selects = select;
        this.operations = ops;
    }

    @Override
    public StringBuilder appendSelectBodyTo(StringBuilder builder) {
        for (int i = 0; i < this.selects.size(); ++i) {
            if (i != 0) {
                builder.append(" ").append(this.operations.get(i - 1).toString()).append(" ");
            }
            builder.append(this.selects.get(i).toString());
        }
        if (this.orderByElements != null) {
            builder.append(PlainSelect.orderByToString(this.orderByElements));
        }
        return builder;
    }

    public SetOperationList withOperations(List<SetOperation> operationList) {
        this.setOperations(operationList);
        return this;
    }

    public SetOperationList withSelects(List<Select> selects) {
        this.setSelects(selects);
        return this;
    }

    public SetOperationList addSelects(Select ... selects) {
        List collection = Optional.ofNullable(this.getSelects()).orElseGet(ArrayList::new);
        Collections.addAll(collection, selects);
        return this.withSelects(collection);
    }

    public SetOperationList addSelects(Collection<? extends Select> selects) {
        List collection = Optional.ofNullable(this.getSelects()).orElseGet(ArrayList::new);
        collection.addAll(selects);
        return this.withSelects(collection);
    }

    public SetOperationList addOperations(SetOperation ... operationList) {
        List collection = Optional.ofNullable(this.getOperations()).orElseGet(ArrayList::new);
        Collections.addAll(collection, operationList);
        return this.withOperations(collection);
    }

    public SetOperationList addOperations(Collection<? extends SetOperation> operationList) {
        List collection = Optional.ofNullable(this.getOperations()).orElseGet(ArrayList::new);
        collection.addAll(operationList);
        return this.withOperations(collection);
    }

    public static enum SetOperationType {
        INTERSECT,
        EXCEPT,
        MINUS,
        UNION;


        public static SetOperationType from(String type) {
            return Enum.valueOf(SetOperationType.class, type.toUpperCase());
        }
    }
}

