/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util;

import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.JSQLParserException;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.expression.Expression;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.schema.Table;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.AllColumns;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.Join;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.PlainSelect;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.Select;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.statement.select.SelectItem;

public final class SelectUtils {
    private static final String NOT_SUPPORTED_YET = "Not supported yet.";

    private SelectUtils() {
    }

    public static Select buildSelectFromTableAndExpressions(Table table, Expression ... expr) {
        SelectItem[] list = new SelectItem[expr.length];
        for (int i = 0; i < expr.length; ++i) {
            list[i] = new SelectItem<Expression>(expr[i]);
        }
        return SelectUtils.buildSelectFromTableAndSelectItems(table, list);
    }

    public static Select buildSelectFromTableAndExpressions(Table table, String ... expr) throws JSQLParserException {
        SelectItem[] list = new SelectItem[expr.length];
        for (int i = 0; i < expr.length; ++i) {
            list[i] = new SelectItem<Expression>(CCJSqlParserUtil.parseExpression(expr[i]));
        }
        return SelectUtils.buildSelectFromTableAndSelectItems(table, list);
    }

    public static Select buildSelectFromTableAndSelectItems(Table table, SelectItem ... selectItems) {
        PlainSelect select = new PlainSelect().addSelectItems(selectItems).withFromItem(table);
        return select;
    }

    public static Select buildSelectFromTable(Table table) {
        return SelectUtils.buildSelectFromTableAndSelectItems(table, SelectItem.from(new AllColumns()));
    }

    public static void addExpression(Select select, Expression expr) {
        if (!(select instanceof PlainSelect)) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
        }
        ((PlainSelect)select).addSelectItem(expr);
    }

    public static Join addJoin(Select select, Table table, Expression onExpression) {
        if (select instanceof PlainSelect) {
            Join join = new Join().withRightItem(table).addOnExpression(onExpression);
            ((PlainSelect)select).addJoins(join);
            return join;
        }
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    public static void addGroupBy(Select select, Expression expr) {
        if (!(select instanceof PlainSelect)) {
            throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
        }
        ((PlainSelect)select).addGroupByColumnReference(expr);
    }
}

