/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.allowedtypes;

import java.util.Collection;
import java.util.function.Consumer;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.ValidationCapability;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.ValidationContext;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.ValidationException;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.allowedtypes.AllowedTypesContext;

public class AllowedTypesValidation
implements ValidationCapability {
    public static final String NAME = "allowed types";

    @Override
    public void validate(ValidationContext context, Consumer<ValidationException> errorConsumer) {
        Object arg = context.getOptional(AllowedTypesContext.argument, Object.class);
        Boolean allowNull = context.getOptional(AllowedTypesContext.allow_null, Boolean.class);
        Collection allowedTypes = context.get(AllowedTypesContext.allowed_types, Collection.class);
        if (arg != null) {
            boolean error = true;
            for (Class cls : allowedTypes) {
                if (!cls.isAssignableFrom(arg.getClass())) continue;
                error = false;
                break;
            }
            if (error) {
                errorConsumer.accept(this.toError(arg.getClass() + " is not a valid argument - expected one of " + allowedTypes));
            }
        } else if (Boolean.FALSE.equals(allowNull)) {
            errorConsumer.accept(this.toError("argument is missing one of " + allowedTypes));
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

