/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.feature;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.parser.feature.Feature;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.feature.DatabaseType;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.feature.Version;

public enum OracleVersion implements Version
{
    V19C("19c", EnumSet.of(Feature.jdbcParameter, new Feature[]{Feature.jdbcNamedParameter, Feature.exprLike, Feature.select, Feature.selectGroupBy, Feature.function, Feature.selectGroupByGroupingSets, Feature.selectHaving, Feature.join, Feature.joinSimple, Feature.joinLeft, Feature.joinRight, Feature.joinFull, Feature.joinCross, Feature.joinNatural, Feature.joinOuter, Feature.joinInner, Feature.joinApply, Feature.joinUsingColumns, Feature.offset, Feature.offsetParam, Feature.fetch, Feature.fetchFirst, Feature.fetchNext, Feature.distinct, Feature.selectUnique, Feature.orderBy, Feature.orderByNullOrdering, Feature.withItem, Feature.lateralSubSelect, Feature.setOperation, Feature.setOperationUnion, Feature.setOperationIntersect, Feature.setOperationMinus, Feature.selectForUpdate, Feature.selectForUpdateWait, Feature.selectForUpdateNoWait, Feature.selectForUpdateSkipLocked, Feature.insert, Feature.insertValues, Feature.values, Feature.insertFromSelect, Feature.update, Feature.updateReturning, Feature.updateUseSelect, Feature.delete, Feature.deleteReturningExpressionList, Feature.truncate, Feature.drop, Feature.dropTable, Feature.dropIndex, Feature.dropView, Feature.dropSequence, Feature.alterTable, Feature.alterSequence, Feature.executeStatementImmediate, Feature.createView, Feature.createViewForce, Feature.createOrReplaceView, Feature.createViewMaterialized, Feature.createTable, Feature.createTableCreateOptionStrings, Feature.createTableTableOptionStrings, Feature.createTableFromSelect, Feature.createTableRowMovement, Feature.createIndex, Feature.createSequence, Feature.createTrigger, Feature.createSchema, Feature.commit, Feature.comment, Feature.commentOnTable, Feature.commentOnColumn, Feature.commentOnView, Feature.describe, Feature.grant, Feature.merge, Feature.createFunction, Feature.createProcedure, Feature.functionalStatement, Feature.block, Feature.declare, Feature.oracleOldJoinSyntax, Feature.oraclePriorPosition, Feature.oracleHint, Feature.oracleHierarchicalExpression, Feature.oracleOrderBySiblings}));

    private Set<Feature> features;
    private String versionString;

    private OracleVersion(String versionString, Set<Feature> featuresSupported) {
        this(versionString, featuresSupported, Collections.emptySet());
    }

    private OracleVersion(String versionString, Set<Feature> featuresSupported, Set<Feature> unsupported) {
        this.versionString = versionString;
        this.features = featuresSupported;
        this.features.removeAll(unsupported);
    }

    @Override
    public String getVersionString() {
        return this.versionString;
    }

    @Override
    public Set<Feature> getFeatures() {
        return this.features;
    }

    @Override
    public String getName() {
        return DatabaseType.ORACLE.getName() + " " + this.getVersionString();
    }
}

