/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.metadata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.UnexpectedValidationException;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.ValidationException;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.metadata.AbstractDatabaseMetaDataCapability;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.metadata.DatabaseException;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.metadata.Named;
import org.apache.seatunnel.shade.connector-iceberg.net.sf.jsqlparser.util.validation.metadata.NamedObject;

public class JdbcDatabaseMetaDataCapability
extends AbstractDatabaseMetaDataCapability {
    private static final String VIEW = "VIEW";
    private static final String TABLE = "TABLE";
    private static final String COLUMN = "COLUMN";
    private static final Logger LOG = Logger.getLogger(JdbcDatabaseMetaDataCapability.class.getName());

    public JdbcDatabaseMetaDataCapability(Connection connection, UnaryOperator<String> namesLookup) {
        super(connection, namesLookup);
    }

    public JdbcDatabaseMetaDataCapability(Connection connection, UnaryOperator<String> namesLookup, boolean cacheResults) {
        super(connection, namesLookup, cacheResults);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean columnExists(Map<Named, Boolean> results, Named named) throws ValidationException {
        String[] names = this.splitAndValidateMinMax(COLUMN, named.getFqnLookup(), 1, 4);
        String columnName = names[names.length - 1];
        List<Object> possibleParents = null;
        List<NamedObject> parents = named.getParents().isEmpty() ? Arrays.asList(NamedObject.table) : named.getParents();
        int lastIndexOf = named.getFqnLookup().lastIndexOf(".");
        String fqnParent = lastIndexOf != -1 ? named.getFqnLookup().substring(0, lastIndexOf) : null;
        Predicate<Named> predicate = null;
        predicate = fqnParent != null ? n -> parents.contains((Object)n.getNamedObject()) && (fqnParent.equals(n.getAliasLookup()) || fqnParent.equals(n.getFqnLookup())) : n -> parents.contains((Object)n.getNamedObject());
        possibleParents = results.keySet().stream().filter(predicate).map(Named::getFqnLookup).collect(Collectors.toList());
        if (possibleParents.isEmpty()) {
            possibleParents = Collections.singletonList(fqnParent);
        }
        Iterator iterator = possibleParents.iterator();
        block14: while (iterator.hasNext()) {
            String fqn = (String)iterator.next();
            if (this.existsFromItem(results, fqn)) {
                String query = String.format("SELECT * FROM %s", fqn);
                try {
                    PreparedStatement ps = this.connection.prepareStatement(query);
                    Throwable throwable = null;
                    try {
                        ResultSetMetaData metaData = ps.getMetaData();
                        int i = 1;
                        while (true) {
                            if (i > metaData.getColumnCount()) continue block14;
                            if (columnName.equalsIgnoreCase(metaData.getColumnLabel(i))) {
                                boolean bl = true;
                                return bl;
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ps == null) continue;
                        if (throwable != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ps.close();
                        continue;
                    }
                }
                catch (SQLException e) {
                    throw this.createDatabaseException(fqn, COLUMN, e);
                }
            }
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.fine(String.format("%s does not exists, cannot evaluate COLUMN from %s", fqn, named.getFqn()));
        }
        return false;
    }

    private boolean existsFromItem(Map<Named, Boolean> results, String fqn) {
        Named named = new Named(NamedObject.table, fqn).setFqnLookup(fqn);
        return this.viewExists(results, named) || this.tableExists(results, named);
    }

    @Override
    protected boolean viewExists(Map<Named, Boolean> results, Named named) throws ValidationException {
        return this.jdbcMetadataTables(named, VIEW);
    }

    @Override
    protected boolean tableExists(Map<Named, Boolean> results, Named named) throws ValidationException {
        return this.jdbcMetadataTables(named, TABLE);
    }

    protected boolean jdbcMetadataTables(Named named, String type) throws ValidationException {
        String tableNamePattern;
        String[] names = this.splitAndValidateMinMax(type, named.getFqnLookup(), 1, 3);
        String catalog = null;
        String schemaPattern = null;
        if (names.length > 2) {
            catalog = names[0];
            schemaPattern = names[1];
            tableNamePattern = names[2];
        } else if (names.length > 1) {
            schemaPattern = names[0];
            tableNamePattern = names[1];
        } else {
            tableNamePattern = names[0];
        }
        ArrayList<String> tables = new ArrayList<String>();
        try (ResultSet rs = this.connection.getMetaData().getTables(catalog, schemaPattern, tableNamePattern, new String[]{type});){
            while (rs.next()) {
                String tableCat = rs.getString("TABLE_CAT");
                String tableSchem = rs.getString("TABLE_SCHEM");
                String tableName = rs.getString("TABLE_NAME");
                if (!tableName.equalsIgnoreCase(names[names.length - 1])) continue;
                if (names.length > 1) {
                    if (!tableSchem.equalsIgnoreCase(names[names.length - 2])) continue;
                    if (names.length > 2) {
                        if (!tableCat.equalsIgnoreCase(names[names.length - 3])) continue;
                        tables.add(String.join((CharSequence)".", tableCat, tableSchem, tableName));
                        continue;
                    }
                    tables.add(String.join((CharSequence)".", tableSchem, tableName));
                    continue;
                }
                tables.add(tableName);
            }
        }
        catch (SQLException e) {
            throw this.createDatabaseException(named.getFqn(), type, e);
        }
        return !tables.isEmpty();
    }

    private String[] splitAndValidateMinMax(String type, String fqn, int min2, int max) {
        String[] names = fqn.split("\\.");
        if (names.length < min2 || names.length > max) {
            throw new UnexpectedValidationException(String.format("%s path-elements count needs to be between %s and %s for %s", fqn, min2, max, type));
        }
        return names;
    }

    private DatabaseException createDatabaseException(String fqn, String type, SQLException e) {
        return new DatabaseException(String.format("cannot evaluate existence of %s by name '%s'", type, fqn), e);
    }
}

