/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.List;
import java.util.Random;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.EncryptionAlgorithm;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.HadoopShims;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.HadoopShimsPre2_3;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.HadoopShimsPre2_6;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.KeyProvider;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.LocalKey;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.ZeroCopyShims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopShimsPre2_7
implements HadoopShims {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopShimsPre2_7.class);

    @Override
    public HadoopShims.DirectDecompressor getDirectDecompressor(HadoopShims.DirectCompressionType codec) {
        return HadoopShimsPre2_6.getDecompressor(codec);
    }

    @Override
    public HadoopShims.ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream in, HadoopShims.ByteBufferPoolShim pool) throws IOException {
        return ZeroCopyShims.getZeroCopyReader(in, pool);
    }

    @Override
    public boolean endVariableLengthBlock(OutputStream output) {
        return false;
    }

    static String buildKeyVersionName(HadoopShims.KeyMetadata key) {
        return key.getKeyName() + "@" + key.getVersion();
    }

    static KeyProvider createKeyProvider(Configuration conf, Random random) throws IOException {
        List<org.apache.hadoop.crypto.key.KeyProvider> result = KeyProviderFactory.getProviders(conf);
        if (result.size() == 0) {
            LOG.info("Can't get KeyProvider for ORC encryption from hadoop.security.key.provider.path.");
            return new HadoopShimsPre2_3.NullKeyProvider();
        }
        return new KeyProviderImpl(result.get(0), random);
    }

    static EncryptionAlgorithm findAlgorithm(KeyProvider.Metadata meta) {
        String cipher = meta.getCipher();
        if (cipher.startsWith("AES/")) {
            int bitLength = meta.getBitLength();
            if (bitLength == 128) {
                return EncryptionAlgorithm.AES_CTR_128;
            }
            if (bitLength != 256) {
                LOG.info("ORC column encryption does not support " + bitLength + " bit keys. Using 256 bits instead.");
            }
            return EncryptionAlgorithm.AES_CTR_256;
        }
        throw new IllegalArgumentException("ORC column encryption only supports AES and not " + cipher);
    }

    @Override
    public KeyProvider getHadoopKeyProvider(Configuration conf, Random random) throws IOException {
        return HadoopShimsPre2_7.createKeyProvider(conf, random);
    }

    static class KeyProviderImpl
    implements KeyProvider {
        private final org.apache.hadoop.crypto.key.KeyProvider provider;
        private final Random random;

        KeyProviderImpl(org.apache.hadoop.crypto.key.KeyProvider provider, Random random) {
            this.provider = provider;
            this.random = random;
        }

        @Override
        public List<String> getKeyNames() throws IOException {
            return this.provider.getKeys();
        }

        @Override
        public HadoopShims.KeyMetadata getCurrentKeyVersion(String keyName) throws IOException {
            KeyProvider.Metadata meta = this.provider.getMetadata(keyName);
            return new HadoopShims.KeyMetadata(keyName, meta.getVersions() - 1, HadoopShimsPre2_7.findAlgorithm(meta));
        }

        private static void unmangleIv(byte[] input, byte[] output) {
            for (int i = 0; i < output.length && i < input.length; ++i) {
                output[i] = (byte)(0xFF ^ input[i]);
            }
        }

        @Override
        public LocalKey createLocalKey(HadoopShims.KeyMetadata key) throws IOException {
            EncryptionAlgorithm algorithm = key.getAlgorithm();
            byte[] encryptedKey = new byte[algorithm.keyLength()];
            this.random.nextBytes(encryptedKey);
            byte[] iv = new byte[algorithm.getIvLength()];
            KeyProviderImpl.unmangleIv(encryptedKey, iv);
            KeyProviderCryptoExtension.EncryptedKeyVersion param = KeyProviderCryptoExtension.EncryptedKeyVersion.createForDecryption(key.getKeyName(), HadoopShimsPre2_7.buildKeyVersionName(key), iv, encryptedKey);
            try {
                KeyProvider.KeyVersion decryptedKey;
                if (this.provider instanceof KeyProviderCryptoExtension) {
                    decryptedKey = ((KeyProviderCryptoExtension)this.provider).decryptEncryptedKey(param);
                } else if (this.provider instanceof KeyProviderCryptoExtension.CryptoExtension) {
                    decryptedKey = ((KeyProviderCryptoExtension.CryptoExtension)((Object)this.provider)).decryptEncryptedKey(param);
                } else {
                    throw new UnsupportedOperationException(this.provider.getClass().getCanonicalName() + " is not supported.");
                }
                return new LocalKey(algorithm, decryptedKey.getMaterial(), encryptedKey);
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Can't create local encryption key for " + key, e);
            }
        }

        @Override
        public Key decryptLocalKey(HadoopShims.KeyMetadata key, byte[] encryptedKey) throws IOException {
            EncryptionAlgorithm algorithm = key.getAlgorithm();
            byte[] iv = new byte[algorithm.getIvLength()];
            KeyProviderImpl.unmangleIv(encryptedKey, iv);
            KeyProviderCryptoExtension.EncryptedKeyVersion param = KeyProviderCryptoExtension.EncryptedKeyVersion.createForDecryption(key.getKeyName(), HadoopShimsPre2_7.buildKeyVersionName(key), iv, encryptedKey);
            try {
                KeyProvider.KeyVersion decryptedKey;
                if (this.provider instanceof KeyProviderCryptoExtension) {
                    decryptedKey = ((KeyProviderCryptoExtension)this.provider).decryptEncryptedKey(param);
                } else if (this.provider instanceof KeyProviderCryptoExtension.CryptoExtension) {
                    decryptedKey = ((KeyProviderCryptoExtension.CryptoExtension)((Object)this.provider)).decryptEncryptedKey(param);
                } else {
                    throw new UnsupportedOperationException(this.provider.getClass().getCanonicalName() + " is not supported.");
                }
                return new SecretKeySpec(decryptedKey.getMaterial(), algorithm.getAlgorithm());
            }
            catch (GeneralSecurityException e) {
                return null;
            }
        }

        @Override
        public HadoopShims.KeyProviderKind getKind() {
            return HadoopShims.KeyProviderKind.HADOOP;
        }
    }
}

