/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.function.Consumer;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.hadoop.io.BytesWritable;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.CompressionCodec;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.PhysicalWriter;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.PositionRecorder;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.PositionedOutputStream;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.writer.StreamOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutStream
extends PositionedOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(OutStream.class);
    static final Logger KEY_LOGGER = LoggerFactory.getLogger((String)"org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.keys");
    public static final int HEADER_SIZE = 3;
    private final Object name;
    private final PhysicalWriter.OutputReceiver receiver;
    private ByteBuffer current = null;
    private ByteBuffer compressed = null;
    private ByteBuffer overflow = null;
    private final int bufferSize;
    private final CompressionCodec codec;
    private final CompressionCodec.Options options;
    private long compressedBytes = 0L;
    private long uncompressedBytes = 0L;
    private final Cipher cipher;
    private final Key key;
    private final byte[] iv;

    public OutStream(Object name, StreamOptions options, PhysicalWriter.OutputReceiver receiver) {
        this.name = name;
        this.bufferSize = options.getBufferSize();
        this.codec = options.getCodec();
        this.options = options.getCodecOptions();
        this.receiver = receiver;
        if (options.isEncrypted()) {
            this.cipher = options.getAlgorithm().createCipher();
            this.key = options.getKey();
            this.iv = options.getIv();
            this.resetState();
        } else {
            this.cipher = null;
            this.key = null;
            this.iv = null;
        }
        LOG.debug("Stream {} written to with {}", name, (Object)options);
        OutStream.logKeyAndIv(name, this.key, this.iv);
    }

    static void logKeyAndIv(Object name, Key key, byte[] iv) {
        if (iv != null && KEY_LOGGER.isDebugEnabled()) {
            KEY_LOGGER.debug("Stream: {} Key: {} IV: {}", new Object[]{name, new BytesWritable(key.getEncoded()), new BytesWritable(iv)});
        }
    }

    @Override
    public void changeIv(Consumer<byte[]> modifier) {
        if (this.iv != null) {
            modifier.accept(this.iv);
            this.resetState();
            OutStream.logKeyAndIv(this.name, this.key, this.iv);
        }
    }

    private void resetState() {
        try {
            this.cipher.init(1, this.key, new IvParameterSpec(this.iv));
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("ORC bad encryption key for " + this.toString(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalStateException("ORC bad encryption parameter for " + this.toString(), e);
        }
    }

    void outputBuffer(ByteBuffer buffer) throws IOException {
        block4: {
            if (this.cipher != null) {
                ByteBuffer output = buffer.duplicate();
                int len = buffer.remaining();
                try {
                    int encrypted = this.cipher.update(buffer, output);
                    output.flip();
                    this.receiver.output(output);
                    if (encrypted != len) {
                        throw new IllegalArgumentException("Encryption of incomplete buffer " + len + " -> " + encrypted + " in " + this.toString());
                    }
                    break block4;
                }
                catch (ShortBufferException e) {
                    throw new IOException("Short buffer in encryption in " + this.toString(), e);
                }
            }
            this.receiver.output(buffer);
        }
    }

    void finishEncryption() {
        try {
            byte[] finalBytes = this.cipher.doFinal();
            if (finalBytes != null && finalBytes.length != 0) {
                throw new IllegalStateException("We shouldn't have remaining bytes " + this.toString());
            }
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalArgumentException("Bad block size", e);
        }
        catch (BadPaddingException e) {
            throw new IllegalArgumentException("Bad padding", e);
        }
    }

    private static void writeHeader(ByteBuffer buffer, int position, int val, boolean original) {
        buffer.put(position, (byte)((val << 1) + (original ? 1 : 0)));
        buffer.put(position + 1, (byte)(val >> 7));
        buffer.put(position + 2, (byte)(val >> 15));
    }

    private void getNewInputBuffer() {
        if (this.codec == null) {
            this.current = ByteBuffer.allocate(this.bufferSize);
        } else {
            this.current = ByteBuffer.allocate(this.bufferSize + 3);
            OutStream.writeHeader(this.current, 0, this.bufferSize, true);
            this.current.position(3);
        }
    }

    public static void assertBufferSizeValid(int bufferSize) throws IllegalArgumentException {
        if (bufferSize >= 0x800000) {
            throw new IllegalArgumentException("Illegal value of ORC compression buffer size: " + bufferSize);
        }
    }

    private ByteBuffer getNewOutputBuffer() {
        return ByteBuffer.allocate(this.bufferSize + 3);
    }

    private void flip() {
        this.current.limit(this.current.position());
        this.current.position(this.codec == null ? 0 : 3);
    }

    @Override
    public void write(int i) throws IOException {
        if (this.current == null) {
            this.getNewInputBuffer();
        }
        if (this.current.remaining() < 1) {
            this.spill();
        }
        ++this.uncompressedBytes;
        this.current.put((byte)i);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        if (this.current == null) {
            this.getNewInputBuffer();
        }
        int remaining = Math.min(this.current.remaining(), length);
        this.current.put(bytes, offset, remaining);
        this.uncompressedBytes += (long)remaining;
        length -= remaining;
        while (length != 0) {
            this.spill();
            remaining = Math.min(this.current.remaining(), length);
            this.current.put(bytes, offset += remaining, remaining);
            this.uncompressedBytes += (long)remaining;
            length -= remaining;
        }
    }

    private void spill() throws IOException {
        if (this.current == null || this.current.position() == (this.codec == null ? 0 : 3)) {
            return;
        }
        this.flip();
        if (this.codec == null) {
            this.outputBuffer(this.current);
            this.getNewInputBuffer();
        } else {
            if (this.compressed == null) {
                this.compressed = this.getNewOutputBuffer();
            } else if (this.overflow == null) {
                this.overflow = this.getNewOutputBuffer();
            }
            int sizePosn = this.compressed.position();
            this.compressed.position(this.compressed.position() + 3);
            if (this.codec.compress(this.current, this.compressed, this.overflow, this.options)) {
                this.uncompressedBytes = 0L;
                this.current.position(3);
                this.current.limit(this.current.capacity());
                int totalBytes = this.compressed.position() - sizePosn - 3;
                if (this.overflow != null) {
                    totalBytes += this.overflow.position();
                }
                this.compressedBytes += (long)(totalBytes + 3);
                OutStream.writeHeader(this.compressed, sizePosn, totalBytes, false);
                if (this.compressed.remaining() < 3) {
                    this.compressed.flip();
                    this.outputBuffer(this.compressed);
                    this.compressed = this.overflow;
                    this.overflow = null;
                }
            } else {
                this.compressedBytes += this.uncompressedBytes + 3L;
                this.uncompressedBytes = 0L;
                if (sizePosn != 0) {
                    this.compressed.position(sizePosn);
                    this.compressed.flip();
                    this.outputBuffer(this.compressed);
                    this.compressed = null;
                    if (this.overflow != null) {
                        this.overflow.clear();
                        this.compressed = this.overflow;
                        this.overflow = null;
                    }
                } else {
                    this.compressed.clear();
                    if (this.overflow != null) {
                        this.overflow.clear();
                    }
                }
                this.current.position(0);
                OutStream.writeHeader(this.current, 0, this.current.limit() - 3, true);
                this.outputBuffer(this.current);
                this.getNewInputBuffer();
            }
        }
    }

    @Override
    public void getPosition(PositionRecorder recorder) {
        if (this.codec == null) {
            recorder.addPosition(this.uncompressedBytes);
        } else {
            recorder.addPosition(this.compressedBytes);
            recorder.addPosition(this.uncompressedBytes);
        }
    }

    @Override
    public void flush() throws IOException {
        this.spill();
        if (this.compressed != null && this.compressed.position() != 0) {
            this.compressed.flip();
            this.outputBuffer(this.compressed);
        }
        if (this.cipher != null) {
            this.finishEncryption();
        }
        this.compressed = null;
        this.uncompressedBytes = 0L;
        this.compressedBytes = 0L;
        this.overflow = null;
        this.current = null;
    }

    public String toString() {
        return this.name.toString();
    }

    @Override
    public long getBufferSize() {
        if (this.codec == null) {
            return this.uncompressedBytes + (long)(this.current == null ? 0 : this.current.remaining());
        }
        long result = 0L;
        if (this.current != null) {
            result += (long)this.current.capacity();
        }
        if (this.compressed != null) {
            result += (long)this.compressed.capacity();
        }
        if (this.overflow != null) {
            result += (long)this.overflow.capacity();
        }
        return result + this.compressedBytes;
    }

    public void suppress() {
        this.receiver.suppress();
    }
}

