/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.ql.io.sarg;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.common.NoDynamicValuesException;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.ql.io.sarg.ExpressionTree;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.ql.io.sarg.LiteralDelegate;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.ql.io.sarg.PredicateLeaf;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.ql.io.sarg.SearchArgument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchArgumentImpl
implements SearchArgument {
    private static final Logger LOG = LoggerFactory.getLogger(SearchArgumentImpl.class);
    private final List<PredicateLeaf> leaves;
    private final ExpressionTree normalizedExpression;
    private final ExpressionTree compactExpression;

    SearchArgumentImpl(ExpressionTree normalizedExpression, ExpressionTree compactExpression, List<PredicateLeaf> leaves) {
        this.normalizedExpression = normalizedExpression;
        this.compactExpression = compactExpression;
        this.leaves = leaves;
    }

    SearchArgumentImpl() {
        this.leaves = null;
        this.normalizedExpression = null;
        this.compactExpression = null;
    }

    @Override
    public List<PredicateLeaf> getLeaves() {
        return this.leaves;
    }

    @Override
    public SearchArgument.TruthValue evaluate(SearchArgument.TruthValue[] leaves) {
        return this.normalizedExpression == null ? SearchArgument.TruthValue.YES : this.normalizedExpression.evaluate(leaves);
    }

    @Override
    public ExpressionTree getExpression() {
        return this.normalizedExpression;
    }

    @Override
    public ExpressionTree getCompactExpression() {
        return this.compactExpression;
    }

    public String toString() {
        return this.normalizedExpression.toString();
    }

    public String toOldString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; this.leaves != null && i < this.leaves.size(); ++i) {
            buffer.append("leaf-");
            buffer.append(i);
            buffer.append(" = ");
            buffer.append(this.leaves.get(i).toString());
            buffer.append(", ");
        }
        buffer.append("expr = ");
        buffer.append(this.normalizedExpression.toOldString());
        return buffer.toString();
    }

    static class BuilderImpl
    implements SearchArgument.Builder {
        Configuration conf;
        private static final int CNF_COMBINATIONS_THRESHOLD = 256;
        private final Deque<ExpressionTree> currentTree = new ArrayDeque<ExpressionTree>();
        private final Map<PredicateLeaf, PredicateLeaf> leaves = new HashMap<PredicateLeaf, PredicateLeaf>();
        private final ExpressionTree root = new ExpressionTree(ExpressionTree.Operator.AND, new ExpressionTree[0]);

        public BuilderImpl(Configuration conf) {
            this.currentTree.add(this.root);
            this.conf = conf;
        }

        @Override
        public SearchArgument.Builder startOr() {
            ExpressionTree node = new ExpressionTree(ExpressionTree.Operator.OR, new ExpressionTree[0]);
            this.currentTree.getFirst().getChildren().add(node);
            this.currentTree.addFirst(node);
            return this;
        }

        @Override
        public SearchArgument.Builder startAnd() {
            ExpressionTree node = new ExpressionTree(ExpressionTree.Operator.AND, new ExpressionTree[0]);
            this.currentTree.getFirst().getChildren().add(node);
            this.currentTree.addFirst(node);
            return this;
        }

        @Override
        public SearchArgument.Builder startNot() {
            ExpressionTree node = new ExpressionTree(ExpressionTree.Operator.NOT, new ExpressionTree[0]);
            this.currentTree.getFirst().getChildren().add(node);
            this.currentTree.addFirst(node);
            return this;
        }

        @Override
        public SearchArgument.Builder end() {
            ExpressionTree current = this.currentTree.removeFirst();
            if (current.getChildren().size() == 0) {
                throw new IllegalArgumentException("Can't create expression " + this.root + " with no children.");
            }
            if (current.getOperator() == ExpressionTree.Operator.NOT && current.getChildren().size() != 1) {
                throw new IllegalArgumentException("Can't create not expression " + current + " with more than 1 child.");
            }
            return this;
        }

        private PredicateLeaf addLeaf(PredicateLeaf leaf) {
            PredicateLeaf result = this.leaves.get(leaf);
            if (result == null) {
                this.leaves.put(leaf, leaf);
                return leaf;
            }
            return result;
        }

        @Override
        public SearchArgument.Builder lessThan(String column, PredicateLeaf.Type type, Object literal) {
            ExpressionTree parent = this.currentTree.getFirst();
            if (column == null || literal == null) {
                parent.getChildren().add(new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL));
            } else {
                PredicateLeafImpl leaf = new PredicateLeafImpl(PredicateLeaf.Operator.LESS_THAN, type, column, literal, null, this.conf);
                parent.getChildren().add(new ExpressionTree(this.addLeaf(leaf)));
            }
            return this;
        }

        @Override
        public SearchArgument.Builder lessThanEquals(String column, PredicateLeaf.Type type, Object literal) {
            ExpressionTree parent = this.currentTree.getFirst();
            if (column == null || literal == null) {
                parent.getChildren().add(new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL));
            } else {
                PredicateLeafImpl leaf = new PredicateLeafImpl(PredicateLeaf.Operator.LESS_THAN_EQUALS, type, column, literal, null, this.conf);
                parent.getChildren().add(new ExpressionTree(this.addLeaf(leaf)));
            }
            return this;
        }

        @Override
        public SearchArgument.Builder equals(String column, PredicateLeaf.Type type, Object literal) {
            ExpressionTree parent = this.currentTree.getFirst();
            if (column == null || literal == null) {
                parent.getChildren().add(new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL));
            } else {
                PredicateLeafImpl leaf = new PredicateLeafImpl(PredicateLeaf.Operator.EQUALS, type, column, literal, null, this.conf);
                parent.getChildren().add(new ExpressionTree(this.addLeaf(leaf)));
            }
            return this;
        }

        @Override
        public SearchArgument.Builder nullSafeEquals(String column, PredicateLeaf.Type type, Object literal) {
            ExpressionTree parent = this.currentTree.getFirst();
            if (column == null || literal == null) {
                parent.getChildren().add(new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL));
            } else {
                PredicateLeafImpl leaf = new PredicateLeafImpl(PredicateLeaf.Operator.NULL_SAFE_EQUALS, type, column, literal, null, this.conf);
                parent.getChildren().add(new ExpressionTree(this.addLeaf(leaf)));
            }
            return this;
        }

        @Override
        public SearchArgument.Builder in(String column, PredicateLeaf.Type type, Object ... literal) {
            ExpressionTree parent = this.currentTree.getFirst();
            if (column == null || literal == null) {
                parent.getChildren().add(new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL));
            } else {
                if (literal.length == 0) {
                    throw new IllegalArgumentException("Can't create in expression with no arguments");
                }
                ArrayList<Object> argList = new ArrayList<Object>(Arrays.asList(literal));
                PredicateLeafImpl leaf = new PredicateLeafImpl(PredicateLeaf.Operator.IN, type, column, null, argList, this.conf);
                parent.getChildren().add(new ExpressionTree(this.addLeaf(leaf)));
            }
            return this;
        }

        @Override
        public SearchArgument.Builder isNull(String column, PredicateLeaf.Type type) {
            ExpressionTree parent = this.currentTree.getFirst();
            if (column == null) {
                parent.getChildren().add(new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL));
            } else {
                PredicateLeafImpl leaf = new PredicateLeafImpl(PredicateLeaf.Operator.IS_NULL, type, column, null, null, this.conf);
                parent.getChildren().add(new ExpressionTree(this.addLeaf(leaf)));
            }
            return this;
        }

        @Override
        public SearchArgument.Builder between(String column, PredicateLeaf.Type type, Object lower, Object upper) {
            ExpressionTree parent = this.currentTree.getFirst();
            if (column == null || lower == null || upper == null) {
                parent.getChildren().add(new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL));
            } else {
                ArrayList<Object> argList = new ArrayList<Object>();
                argList.add(lower);
                argList.add(upper);
                PredicateLeafImpl leaf = new PredicateLeafImpl(PredicateLeaf.Operator.BETWEEN, type, column, null, argList, this.conf);
                parent.getChildren().add(new ExpressionTree(this.addLeaf(leaf)));
            }
            return this;
        }

        @Override
        public SearchArgument.Builder literal(SearchArgument.TruthValue truth) {
            ExpressionTree parent = this.currentTree.getFirst();
            parent.getChildren().add(new ExpressionTree(truth));
            return this;
        }

        static void compactLeaves(ExpressionTree tree, List<PredicateLeaf> leaves) {
            if (tree.getOperator() == ExpressionTree.Operator.LEAF) {
                PredicateLeafImpl newLeaf = (PredicateLeafImpl)tree.getPredicateLeaf();
                if (newLeaf.getId() == -1) {
                    newLeaf.setId(leaves.size());
                    leaves.add(newLeaf);
                }
            } else if (tree.getChildren() != null) {
                for (ExpressionTree child : tree.getChildren()) {
                    BuilderImpl.compactLeaves(child, leaves);
                }
            }
        }

        @Override
        public SearchArgument build() {
            if (this.currentTree.size() != 1) {
                throw new IllegalArgumentException("Failed to end " + this.currentTree.size() + " operations.");
            }
            ExpressionTree optimized = BuilderImpl.optimize(this.root);
            ExpressionTree expanded = BuilderImpl.convertToCNF(new ExpressionTree(optimized));
            expanded = BuilderImpl.flatten(expanded);
            ArrayList<PredicateLeaf> finalLeaves = new ArrayList<PredicateLeaf>(this.leaves.size());
            BuilderImpl.compactLeaves(expanded, finalLeaves);
            return new SearchArgumentImpl(expanded, optimized, finalLeaves);
        }

        static ExpressionTree optimize(ExpressionTree root) {
            ExpressionTree optimized = BuilderImpl.pushDownNot(root);
            optimized = BuilderImpl.foldMaybe(optimized);
            return BuilderImpl.flatten(optimized);
        }

        static ExpressionTree pushDownNot(ExpressionTree root) {
            block11: {
                block10: {
                    if (root.getOperator() != ExpressionTree.Operator.NOT) break block10;
                    ExpressionTree child = root.getChildren().get(0);
                    switch (child.getOperator()) {
                        case NOT: {
                            return BuilderImpl.pushDownNot(child.getChildren().get(0));
                        }
                        case CONSTANT: {
                            return new ExpressionTree(child.getConstant().not());
                        }
                        case AND: {
                            root = new ExpressionTree(ExpressionTree.Operator.OR, new ExpressionTree[0]);
                            for (ExpressionTree kid : child.getChildren()) {
                                root.getChildren().add(BuilderImpl.pushDownNot(new ExpressionTree(ExpressionTree.Operator.NOT, kid)));
                            }
                            break block11;
                        }
                        case OR: {
                            root = new ExpressionTree(ExpressionTree.Operator.AND, new ExpressionTree[0]);
                            for (ExpressionTree kid : child.getChildren()) {
                                root.getChildren().add(BuilderImpl.pushDownNot(new ExpressionTree(ExpressionTree.Operator.NOT, kid)));
                            }
                            break block11;
                        }
                    }
                    break block11;
                }
                if (root.getChildren() != null) {
                    for (int i = 0; i < root.getChildren().size(); ++i) {
                        root.getChildren().set(i, BuilderImpl.pushDownNot(root.getChildren().get(i)));
                    }
                }
            }
            return root;
        }

        static ExpressionTree foldMaybe(ExpressionTree expr) {
            if (expr.getChildren() != null) {
                block4: for (int i = 0; i < expr.getChildren().size(); ++i) {
                    ExpressionTree child = BuilderImpl.foldMaybe(expr.getChildren().get(i));
                    if (child.getConstant() == SearchArgument.TruthValue.YES_NO_NULL) {
                        switch (expr.getOperator()) {
                            case AND: {
                                expr.getChildren().remove(i);
                                --i;
                                continue block4;
                            }
                            case OR: {
                                return child;
                            }
                            default: {
                                throw new IllegalStateException("Got a maybe as child of " + expr);
                            }
                        }
                    }
                    expr.getChildren().set(i, child);
                }
                if (expr.getChildren().isEmpty()) {
                    return new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL);
                }
            }
            return expr;
        }

        static ExpressionTree flatten(ExpressionTree root) {
            if (root.getChildren() != null) {
                for (int i = 0; i < root.getChildren().size(); ++i) {
                    ExpressionTree child = BuilderImpl.flatten(root.getChildren().get(i));
                    if (child.getOperator() == root.getOperator() && child.getOperator() != ExpressionTree.Operator.NOT) {
                        boolean first = true;
                        for (ExpressionTree grandkid : child.getChildren()) {
                            if (first) {
                                first = false;
                                root.getChildren().set(i, grandkid);
                                continue;
                            }
                            root.getChildren().add(++i, grandkid);
                        }
                        continue;
                    }
                    root.getChildren().set(i, child);
                }
                if ((root.getOperator() == ExpressionTree.Operator.OR || root.getOperator() == ExpressionTree.Operator.AND) && root.getChildren().size() == 1) {
                    return root.getChildren().get(0);
                }
            }
            return root;
        }

        private static void generateAllCombinations(List<ExpressionTree> result, List<ExpressionTree> andList, List<ExpressionTree> nonAndList) {
            List<ExpressionTree> kids = andList.get(0).getChildren();
            if (result.isEmpty()) {
                for (ExpressionTree kid : kids) {
                    ExpressionTree or = new ExpressionTree(ExpressionTree.Operator.OR, new ExpressionTree[0]);
                    result.add(or);
                    for (ExpressionTree node : nonAndList) {
                        or.getChildren().add(new ExpressionTree(node));
                    }
                    or.getChildren().add(kid);
                }
            } else {
                ArrayList<ExpressionTree> work = new ArrayList<ExpressionTree>(result);
                result.clear();
                for (ExpressionTree kid : kids) {
                    for (ExpressionTree or : work) {
                        ExpressionTree copy = new ExpressionTree(or);
                        copy.getChildren().add(kid);
                        result.add(copy);
                    }
                }
            }
            if (andList.size() > 1) {
                BuilderImpl.generateAllCombinations(result, andList.subList(1, andList.size()), nonAndList);
            }
        }

        static ExpressionTree convertToCNF(ExpressionTree root) {
            if (root.getChildren() != null) {
                int size = root.getChildren().size();
                for (int i = 0; i < size; ++i) {
                    root.getChildren().set(i, BuilderImpl.convertToCNF(root.getChildren().get(i)));
                }
                if (root.getOperator() == ExpressionTree.Operator.OR) {
                    ArrayList<ExpressionTree> nonAndList = new ArrayList<ExpressionTree>();
                    ArrayList<ExpressionTree> andList = new ArrayList<ExpressionTree>();
                    for (ExpressionTree child : root.getChildren()) {
                        if (child.getOperator() == ExpressionTree.Operator.AND) {
                            andList.add(child);
                            continue;
                        }
                        if (child.getOperator() == ExpressionTree.Operator.OR) {
                            nonAndList.addAll(child.getChildren());
                            continue;
                        }
                        nonAndList.add(child);
                    }
                    if (!andList.isEmpty()) {
                        if (BuilderImpl.checkCombinationsThreshold(andList)) {
                            root = new ExpressionTree(ExpressionTree.Operator.AND, new ExpressionTree[0]);
                            BuilderImpl.generateAllCombinations(root.getChildren(), andList, nonAndList);
                        } else {
                            root = new ExpressionTree(SearchArgument.TruthValue.YES_NO_NULL);
                        }
                    }
                }
            }
            return root;
        }

        private static boolean checkCombinationsThreshold(List<ExpressionTree> andList) {
            int numComb = 1;
            for (ExpressionTree tree : andList) {
                if ((numComb *= tree.getChildren().size()) <= 256) continue;
                return false;
            }
            return true;
        }
    }

    public static final class PredicateLeafImpl
    implements PredicateLeaf {
        private final PredicateLeaf.Operator operator;
        private final PredicateLeaf.Type type;
        private String columnName;
        private final Object literal;
        private final List<Object> literalList;
        private int id;

        PredicateLeafImpl() {
            this.operator = null;
            this.type = null;
            this.columnName = null;
            this.literal = null;
            this.literalList = null;
            this.id = -1;
        }

        public PredicateLeafImpl(PredicateLeaf.Operator operator, PredicateLeaf.Type type, String columnName, Object literal, List<Object> literalList) {
            this(operator, type, columnName, literal, literalList, null);
        }

        public PredicateLeafImpl(PredicateLeaf.Operator operator, PredicateLeaf.Type type, String columnName, Object literal, List<Object> literalList, Configuration conf) {
            this.operator = operator;
            this.type = type;
            this.columnName = columnName;
            this.literal = literal;
            this.id = -1;
            this.checkLiteralType(literal, type, conf);
            this.literalList = literalList;
            if (literalList != null) {
                for (Object lit : literalList) {
                    this.checkLiteralType(lit, type, conf);
                }
            }
        }

        @Override
        public PredicateLeaf.Operator getOperator() {
            return this.operator;
        }

        @Override
        public PredicateLeaf.Type getType() {
            return this.type;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public Object getLiteral() {
            if (this.literal instanceof LiteralDelegate) {
                return ((LiteralDelegate)this.literal).getLiteral();
            }
            return this.literal;
        }

        @Override
        public List<Object> getLiteralList() {
            if (this.literalList != null && this.literalList.size() > 0 && this.literalList.get(0) instanceof LiteralDelegate) {
                ArrayList<Object> newLiteraList = new ArrayList<Object>();
                try {
                    for (Object litertalObj : this.literalList) {
                        Object literal = ((LiteralDelegate)litertalObj).getLiteral();
                        if (literal == null) continue;
                        newLiteraList.add(literal);
                    }
                }
                catch (NoDynamicValuesException err) {
                    LOG.debug("Error while retrieving literalList, returning null", (Throwable)err);
                    return Collections.emptyList();
                }
                return newLiteraList;
            }
            return this.literalList;
        }

        @Override
        public int getId() {
            return this.id;
        }

        public void setId(int newId) {
            this.id = newId;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('(');
            buffer.append((Object)this.operator);
            buffer.append(' ');
            buffer.append(this.columnName);
            if (this.literal != null) {
                buffer.append(' ');
                buffer.append(this.literal);
            } else if (this.literalList != null) {
                for (Object lit : this.literalList) {
                    buffer.append(' ');
                    buffer.append(lit == null ? "null" : lit.toString());
                }
            }
            buffer.append(')');
            return buffer.toString();
        }

        private static boolean isEqual(Object left, Object right) {
            return left == right || left != null && right != null && left.equals(right);
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            if (other == this) {
                return true;
            }
            PredicateLeafImpl o = (PredicateLeafImpl)other;
            return this.operator == o.operator && this.type == o.type && this.columnName.equals(o.columnName) && PredicateLeafImpl.isEqual(this.literal, o.literal) && PredicateLeafImpl.isEqual(this.literalList, o.literalList);
        }

        public int hashCode() {
            return this.operator.hashCode() + this.type.hashCode() * 17 + this.columnName.hashCode() * 3 * 17 + (this.literal == null ? 0 : this.literal.hashCode()) * 101 * 3 * 17 + (this.literalList == null ? 0 : this.literalList.hashCode()) * 103 * 101 * 3 * 17;
        }

        public static void setColumnName(PredicateLeaf leaf, String newName) {
            assert (leaf instanceof PredicateLeafImpl);
            ((PredicateLeafImpl)leaf).columnName = newName;
        }

        protected void checkLiteralType(Object literal, PredicateLeaf.Type type, Configuration conf) {
            if (literal == null) {
                return;
            }
            if (literal instanceof LiteralDelegate) {
                ((LiteralDelegate)literal).setConf(conf);
            } else if (literal.getClass() != type.getValueClass()) {
                throw new IllegalArgumentException("Wrong value class " + literal.getClass().getName() + " for " + (Object)((Object)type) + "." + (Object)((Object)this.operator) + " leaf");
            }
        }
    }
}

