/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.internal.column.columnindex;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.filter2.predicate.Statistics;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.internal.column.columnindex.ColumnIndexBuilder;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io.api.Binary;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.schema.PrimitiveComparator;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.schema.PrimitiveType;
import org.apache.seatunnel.shade.connector-iceberg.shaded.parquet.it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import org.apache.seatunnel.shade.connector-iceberg.shaded.parquet.it.unimi.dsi.fastutil.doubles.DoubleList;

class DoubleColumnIndexBuilder
extends ColumnIndexBuilder {
    private final DoubleList minValues = new DoubleArrayList();
    private final DoubleList maxValues = new DoubleArrayList();
    private boolean invalid;

    DoubleColumnIndexBuilder() {
    }

    private static double convert(ByteBuffer buffer) {
        return buffer.order(ByteOrder.LITTLE_ENDIAN).getDouble(0);
    }

    private static ByteBuffer convert(double value) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putDouble(0, value);
    }

    @Override
    void addMinMaxFromBytes(ByteBuffer min2, ByteBuffer max) {
        this.minValues.add(DoubleColumnIndexBuilder.convert(min2));
        this.maxValues.add(DoubleColumnIndexBuilder.convert(max));
    }

    @Override
    void addMinMax(Object min2, Object max) {
        double dMin = (Double)min2;
        double dMax = (Double)max;
        if (Double.isNaN(dMin) || Double.isNaN(dMax)) {
            this.invalid = true;
        }
        if (Double.compare(dMin, 0.0) == 0) {
            dMin = -0.0;
        }
        if (Double.compare(dMax, -0.0) == 0) {
            dMax = 0.0;
        }
        this.minValues.add(dMin);
        this.maxValues.add(dMax);
    }

    ColumnIndexBuilder.ColumnIndexBase<Double> createColumnIndex(PrimitiveType type) {
        if (this.invalid) {
            return null;
        }
        DoubleColumnIndex columnIndex = new DoubleColumnIndex(type);
        DoubleColumnIndex.access$102(columnIndex, this.minValues.toDoubleArray());
        DoubleColumnIndex.access$202(columnIndex, this.maxValues.toDoubleArray());
        return columnIndex;
    }

    @Override
    void clearMinMax() {
        this.minValues.clear();
        this.maxValues.clear();
    }

    @Override
    int compareMinValues(PrimitiveComparator<Binary> comparator, int index1, int index2) {
        return comparator.compare(this.minValues.get(index1), this.minValues.get(index2));
    }

    @Override
    int compareMaxValues(PrimitiveComparator<Binary> comparator, int index1, int index2) {
        return comparator.compare(this.maxValues.get(index1), this.maxValues.get(index2));
    }

    @Override
    int sizeOf(Object value) {
        return 8;
    }

    private static class DoubleColumnIndex
    extends ColumnIndexBuilder.ColumnIndexBase<Double> {
        private double[] minValues;
        private double[] maxValues;

        private DoubleColumnIndex(PrimitiveType type) {
            super(type);
        }

        @Override
        ByteBuffer getMinValueAsBytes(int pageIndex) {
            return DoubleColumnIndexBuilder.convert(this.minValues[pageIndex]);
        }

        @Override
        ByteBuffer getMaxValueAsBytes(int pageIndex) {
            return DoubleColumnIndexBuilder.convert(this.maxValues[pageIndex]);
        }

        @Override
        String getMinValueAsString(int pageIndex) {
            return this.stringifier.stringify(this.minValues[pageIndex]);
        }

        @Override
        String getMaxValueAsString(int pageIndex) {
            return this.stringifier.stringify(this.maxValues[pageIndex]);
        }

        @Override
        <T extends Comparable<T>> Statistics<T> createStats(int arrayIndex) {
            return new Statistics<Double>(this.minValues[arrayIndex], this.maxValues[arrayIndex], this.comparator);
        }

        @Override
        ColumnIndexBuilder.ColumnIndexBase.ValueComparator createValueComparator(Object value) {
            final double v = (Double)value;
            return new ColumnIndexBuilder.ColumnIndexBase.ValueComparator(){

                @Override
                int compareValueToMin(int arrayIndex) {
                    return comparator.compare(v, minValues[arrayIndex]);
                }

                @Override
                int compareValueToMax(int arrayIndex) {
                    return comparator.compare(v, maxValues[arrayIndex]);
                }
            };
        }

        static /* synthetic */ double[] access$102(DoubleColumnIndex x0, double[] x1) {
            x0.minValues = x1;
            return x1;
        }

        static /* synthetic */ double[] access$202(DoubleColumnIndex x0, double[] x1) {
            x0.maxValues = x1;
            return x1;
        }
    }
}

