/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.util.Objects;

public final class MutableClock
extends Clock
implements Serializable {
    private static final long serialVersionUID = -6152029959790119695L;
    private final transient InstantHolder instantHolder;
    private final transient ZoneId zone;

    public static MutableClock epochUTC() {
        return MutableClock.of(Instant.EPOCH, ZoneOffset.UTC);
    }

    public static MutableClock of(Instant instant, ZoneId zone) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zone, "zone");
        return new MutableClock(new InstantHolder(instant), zone);
    }

    private MutableClock(InstantHolder instantHolder, ZoneId zone) {
        this.instantHolder = instantHolder;
        this.zone = zone;
    }

    public void setInstant(Instant instant) {
        Objects.requireNonNull(instant, "instant");
        this.instantHolder.set(instant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TemporalAmount amountToAdd) {
        Objects.requireNonNull(amountToAdd, "amountToAdd");
        InstantHolder instantHolder = this.instantHolder;
        synchronized (instantHolder) {
            ZonedDateTime current = ZonedDateTime.ofInstant(this.instantHolder.get(), this.zone);
            ZonedDateTime result = current.plus(amountToAdd);
            this.instantHolder.set(result.toInstant());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long amountToAdd, TemporalUnit unit) {
        Objects.requireNonNull(unit, "unit");
        InstantHolder instantHolder = this.instantHolder;
        synchronized (instantHolder) {
            ZonedDateTime current = ZonedDateTime.ofInstant(this.instantHolder.get(), this.zone);
            ZonedDateTime result = current.plus(amountToAdd, unit);
            this.instantHolder.set(result.toInstant());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(TemporalAdjuster adjuster) {
        Objects.requireNonNull(adjuster, "adjuster");
        InstantHolder instantHolder = this.instantHolder;
        synchronized (instantHolder) {
            ZonedDateTime current = ZonedDateTime.ofInstant(this.instantHolder.get(), this.zone);
            ZonedDateTime result = current.with(adjuster);
            this.instantHolder.set(result.toInstant());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(TemporalField field, long newValue) {
        Objects.requireNonNull(field, "field");
        InstantHolder instantHolder = this.instantHolder;
        synchronized (instantHolder) {
            ZonedDateTime current = ZonedDateTime.ofInstant(this.instantHolder.get(), this.zone);
            ZonedDateTime result = current.with(field, newValue);
            this.instantHolder.set(result.toInstant());
        }
    }

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    @Override
    public MutableClock withZone(ZoneId zone) {
        Objects.requireNonNull(zone, "zone");
        if (zone.equals(this.zone)) {
            return this;
        }
        return new MutableClock(this.instantHolder, zone);
    }

    @Override
    public Instant instant() {
        return this.instantHolder.get();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MutableClock) {
            MutableClock other = (MutableClock)obj;
            return this.instantHolder == other.instantHolder && this.zone.equals(other.zone);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this.instantHolder) ^ this.zone.hashCode();
    }

    public String toString() {
        return "MutableClock[" + this.instant() + "," + this.getZone() + "]";
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream s2) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static final class InstantHolder {
        private volatile Instant value;

        InstantHolder(Instant value) {
            this.value = value;
        }

        Instant get() {
            return this.value;
        }

        void set(Instant value) {
            this.value = value;
        }
    }

    private static final class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 8602110640241828260L;
        private final Instant instant;
        private final ZoneId zone;

        SerializationProxy(MutableClock clock) {
            this.instant = clock.instant();
            this.zone = clock.getZone();
        }

        private Object readResolve() throws InvalidObjectException {
            if (this.instant == null) {
                throw new InvalidObjectException("null instant");
            }
            if (this.zone == null) {
                throw new InvalidObjectException("null zone");
            }
            return MutableClock.of(this.instant, this.zone);
        }
    }
}

