/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.sink;

import com.google.auto.service.AutoService;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.CommonConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.SinkConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.IcebergSink;

@AutoService(value={Factory.class})
public class IcebergSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "Iceberg";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{CommonConfig.KEY_CATALOG_NAME, SinkConfig.KEY_NAMESPACE, SinkConfig.KEY_TABLE, SinkConfig.CATALOG_PROPS}).optional(new Option[]{SinkConfig.TABLE_PROPS, SinkConfig.HADOOP_PROPS, SinkConfig.WRITE_PROPS, SinkConfig.AUTO_CREATE_PROPS, SinkConfig.TABLE_PRIMARY_KEYS, SinkConfig.TABLE_DEFAULT_PARTITION_KEYS, SinkConfig.TABLE_UPSERT_MODE_ENABLED_PROP, SinkConfig.TABLE_SCHEMA_EVOLUTION_ENABLED_PROP, SinkConfig.TABLES_DEFAULT_COMMIT_BRANCH}).build();
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        ReadonlyConfig config = context.getOptions();
        CatalogTable catalogTable = this.renameCatalogTable(new SinkConfig(config), context.getCatalogTable());
        return () -> new IcebergSink(config, catalogTable);
    }

    private CatalogTable renameCatalogTable(SinkConfig sinkConfig, CatalogTable catalogTable) {
        TableIdentifier tableId = catalogTable.getTableId();
        String tableName = StringUtils.isNotEmpty(sinkConfig.getTable()) ? sinkConfig.getTable() : tableId.getTableName();
        String namespace = StringUtils.isNotEmpty(sinkConfig.getNamespace()) ? sinkConfig.getNamespace() : tableId.getSchemaName();
        TableIdentifier newTableId = TableIdentifier.of((String)tableId.getCatalogName(), (String)namespace, (String)tableId.getSchemaName(), (String)tableName);
        return CatalogTable.of((TableIdentifier)newTableId, (CatalogTable)catalogTable);
    }
}

