/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.sink.commit;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.api.sink.SinkAggregatedCommitter;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.connectors.seatunnel.iceberg.IcebergTableLoader;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.SinkConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.commit.IcebergAggregatedCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.commit.IcebergCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.commit.IcebergFilesCommitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergAggregatedCommitter
implements SinkAggregatedCommitter<IcebergCommitInfo, IcebergAggregatedCommitInfo> {
    private static final Logger log = LoggerFactory.getLogger(IcebergAggregatedCommitter.class);
    private final IcebergFilesCommitter filesCommitter;

    public IcebergAggregatedCommitter(SinkConfig config, CatalogTable catalogTable) {
        IcebergTableLoader tableLoader = IcebergTableLoader.create(config, catalogTable).open();
        this.filesCommitter = IcebergFilesCommitter.of(config, tableLoader);
    }

    public List<IcebergAggregatedCommitInfo> commit(List<IcebergAggregatedCommitInfo> aggregatedCommitInfo) throws IOException {
        for (IcebergAggregatedCommitInfo commitInfo : aggregatedCommitInfo) {
            this.commitFiles(commitInfo.commitInfos);
        }
        return Collections.emptyList();
    }

    private void commitFiles(List<IcebergCommitInfo> commitInfos) {
        for (IcebergCommitInfo icebergCommitInfo : commitInfos) {
            if (icebergCommitInfo.getResults() == null) continue;
            this.filesCommitter.doCommit(icebergCommitInfo.getResults());
        }
    }

    public IcebergAggregatedCommitInfo combine(List<IcebergCommitInfo> commitInfos) {
        return new IcebergAggregatedCommitInfo(commitInfos);
    }

    public void abort(List<IcebergAggregatedCommitInfo> aggregatedCommitInfo) throws Exception {
    }

    public void close() throws IOException {
    }
}

