/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.sink.writer;

import java.io.IOException;
import java.util.Set;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.BaseTaskWriter;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.types.TypeUtil;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.writer.IcebergRecord;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.writer.RecordProjection;
import org.apache.seatunnel.shade.com.google.common.collect.Sets;

abstract class BaseDeltaTaskWriter
extends BaseTaskWriter<Record> {
    private final Schema schema;
    private final Schema deleteSchema;
    private final InternalRecordWrapper wrapper;
    private final InternalRecordWrapper keyWrapper;
    private final RecordProjection keyProjection;
    private final boolean upsert;

    BaseDeltaTaskWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<Record> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize, Schema schema, Set<Integer> identifierFieldIds, boolean upsert) {
        super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
        this.schema = schema;
        this.deleteSchema = TypeUtil.select(schema, (Set<Integer>)Sets.newHashSet(identifierFieldIds));
        this.wrapper = new InternalRecordWrapper(schema.asStruct());
        this.keyWrapper = new InternalRecordWrapper(this.deleteSchema.asStruct());
        this.keyProjection = RecordProjection.create(schema, this.deleteSchema);
        this.upsert = upsert;
    }

    abstract RowDataDeltaWriter route(IcebergRecord var1);

    InternalRecordWrapper wrapper() {
        return this.wrapper;
    }

    @Override
    public void write(Record record) throws IOException {
        if (!(record instanceof IcebergRecord)) {
            throw new RuntimeException();
        }
        IcebergRecord row = (IcebergRecord)record;
        RowDataDeltaWriter writer = this.route(row);
        switch (row.getRowKind()) {
            case INSERT: 
            case UPDATE_AFTER: {
                if (this.upsert) {
                    writer.deleteKey(this.keyProjection.wrap(row));
                }
                writer.write(row);
                break;
            }
            case UPDATE_BEFORE: {
                if (this.upsert) break;
                writer.delete(row);
                break;
            }
            case DELETE: {
                if (this.upsert) {
                    writer.deleteKey(this.keyProjection.wrap(row));
                    break;
                }
                writer.delete(row);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown row kind: " + row.getRowKind());
            }
        }
    }

    class RowDataDeltaWriter
    extends BaseTaskWriter.BaseEqualityDeltaWriter {
        RowDataDeltaWriter(PartitionKey partition) {
            super(BaseDeltaTaskWriter.this, partition, BaseDeltaTaskWriter.this.schema, BaseDeltaTaskWriter.this.deleteSchema);
        }

        protected StructLike asStructLike(Record data) {
            return BaseDeltaTaskWriter.this.wrapper.wrap(data);
        }

        protected StructLike asStructLikeKey(Record data) {
            return BaseDeltaTaskWriter.this.keyWrapper.wrap(data);
        }
    }
}

