/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.sink.writer;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.types.Types;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.writer.IcebergRecord;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class RecordProjection
implements Record {
    private final Types.StructType type;
    private final int[] positionMap;
    private final RecordProjection[] nestedProjections;
    private IcebergRecord record;

    public static RecordProjection create(Schema dataSchema, Schema projectedSchema) {
        return new RecordProjection(dataSchema.asStruct(), projectedSchema.asStruct());
    }

    private RecordProjection(Types.StructType structType, Types.StructType projection) {
        this(structType, projection, false);
    }

    private RecordProjection(Types.StructType structType, Types.StructType projection, boolean allowMissing) {
        this.type = projection;
        this.positionMap = new int[projection.fields().size()];
        this.nestedProjections = new RecordProjection[projection.fields().size()];
        List<Types.NestedField> dataFields = structType.fields();
        for (int pos = 0; pos < this.positionMap.length; ++pos) {
            Types.NestedField projectedField = projection.fields().get(pos);
            boolean found = false;
            block6: for (int i = 0; !found && i < dataFields.size(); ++i) {
                Types.NestedField dataField = dataFields.get(i);
                if (projectedField.fieldId() != dataField.fieldId()) continue;
                found = true;
                this.positionMap[pos] = i;
                switch (projectedField.type().typeId()) {
                    case STRUCT: {
                        this.nestedProjections[pos] = new RecordProjection(dataField.type().asStructType(), projectedField.type().asStructType());
                        continue block6;
                    }
                    case MAP: {
                        Types.MapType projectedMap = projectedField.type().asMapType();
                        Types.MapType originalMap = dataField.type().asMapType();
                        boolean keyProjectable = !projectedMap.keyType().isNestedType() || projectedMap.keyType().equals(originalMap.keyType());
                        boolean valueProjectable = !projectedMap.valueType().isNestedType() || projectedMap.valueType().equals(originalMap.valueType());
                        Preconditions.checkArgument((keyProjectable && valueProjectable ? 1 : 0) != 0, (String)"Cannot project a partial map key or value struct. Trying to project %s out of %s", (Object)projectedField, (Object)dataField);
                        this.nestedProjections[pos] = null;
                        continue block6;
                    }
                    case LIST: {
                        Types.ListType projectedList = projectedField.type().asListType();
                        Types.ListType originalList = dataField.type().asListType();
                        boolean elementProjectable = !projectedList.elementType().isNestedType() || projectedList.elementType().equals(originalList.elementType());
                        Preconditions.checkArgument((boolean)elementProjectable, (String)"Cannot project a partial list element struct. Trying to project %s out of %s", (Object)projectedField, (Object)dataField);
                        this.nestedProjections[pos] = null;
                        continue block6;
                    }
                    default: {
                        this.nestedProjections[pos] = null;
                    }
                }
            }
            if (!found && projectedField.isOptional() && allowMissing) {
                this.positionMap[pos] = -1;
                this.nestedProjections[pos] = null;
                continue;
            }
            if (found) continue;
            throw new IllegalArgumentException(String.format("Cannot find field %s in %s", projectedField, structType));
        }
    }

    public RecordProjection wrap(IcebergRecord newRecord) {
        this.record = newRecord;
        return this;
    }

    @Override
    public int size() {
        return this.type.fields().size();
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        if (this.record == null) {
            return null;
        }
        int recordPos = this.positionMap[pos];
        if (this.nestedProjections[pos] != null) {
            IcebergRecord nestedStruct = this.record.get(recordPos, IcebergRecord.class);
            if (nestedStruct == null) {
                return null;
            }
            return javaClass.cast(this.nestedProjections[pos].wrap(nestedStruct));
        }
        if (recordPos != -1) {
            return this.record.get(recordPos, javaClass);
        }
        return null;
    }

    @Override
    public <T> void set(int pos, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Types.StructType struct() {
        return this.type;
    }

    @Override
    public Object getField(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setField(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(int pos) {
        return this.get(pos, Object.class);
    }

    @Override
    public Record copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Record copy(Map<String, Object> overwriteValues) {
        throw new UnsupportedOperationException();
    }
}

