/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.source.reader;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.GenericDeleteFilter;
import org.apache.iceberg.data.IdentityPartitionConverters;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.PartitionUtil;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.iceberg.data.IcebergRecordProjection;
import org.apache.seatunnel.connectors.seatunnel.iceberg.exception.IcebergConnectorException;

public class IcebergFileScanTaskReader
implements Closeable {
    private final FileIO fileIO;
    private final Schema tableSchema;
    private final Schema projectedSchema;
    private final boolean caseSensitive;
    private final boolean reuseContainers;

    public CloseableIterator<Record> open(@NonNull FileScanTask task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        CloseableIterable<Record> iterable = this.icebergGenericRead(task);
        return iterable.iterator();
    }

    private CloseableIterable<Record> icebergGenericRead(FileScanTask task) {
        GenericDeleteFilter deletes = new GenericDeleteFilter(this.fileIO, task, this.tableSchema, this.projectedSchema);
        Schema readSchema = deletes.requiredSchema();
        CloseableIterable<Record> records = this.openFile(task, readSchema);
        records = deletes.filter(records);
        records = this.applyResidual(records, readSchema, task.residual());
        if (!this.projectedSchema.sameSchema(readSchema)) {
            records = CloseableIterable.transform(records, record -> new IcebergRecordProjection((Record)record, readSchema.asStruct(), this.projectedSchema.asStruct()));
        }
        return records;
    }

    private CloseableIterable<Record> applyResidual(CloseableIterable<Record> records, Schema recordSchema, Expression residual) {
        if (residual != null && residual != Expressions.alwaysTrue()) {
            InternalRecordWrapper wrapper = new InternalRecordWrapper(recordSchema.asStruct());
            Evaluator filter = new Evaluator(recordSchema.asStruct(), residual, this.caseSensitive);
            return CloseableIterable.filter(records, record -> filter.eval(wrapper.wrap((StructLike)record)));
        }
        return records;
    }

    private CloseableIterable<Record> openFile(FileScanTask task, Schema fileProjection) {
        if (task.isDataTask()) {
            throw new IcebergConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "Cannot read data task.");
        }
        InputFile input = this.fileIO.newInputFile(((DataFile)task.file()).path().toString());
        Map<Integer, ?> partition = PartitionUtil.constantsMap(task, IdentityPartitionConverters::convertConstant);
        switch (((DataFile)task.file()).format()) {
            case AVRO: {
                Avro.ReadBuilder avro = Avro.read(input).project(fileProjection).createReaderFunc(avroSchema -> DataReader.create(fileProjection, avroSchema, partition)).split(task.start(), task.length());
                if (this.reuseContainers) {
                    avro.reuseContainers();
                }
                return avro.build();
            }
            case PARQUET: {
                Parquet.ReadBuilder parquet = Parquet.read(input).caseSensitive(this.caseSensitive).project(fileProjection).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader(fileProjection, fileSchema, partition)).split(task.start(), task.length()).filter(task.residual());
                if (this.reuseContainers) {
                    parquet.reuseContainers();
                }
                return parquet.build();
            }
            case ORC: {
                Schema projectionWithoutConstantAndMetadataFields = TypeUtil.selectNot(fileProjection, (Set<Integer>)Sets.union(partition.keySet(), MetadataColumns.metadataFieldIds()));
                ORC.ReadBuilder orc = ORC.read(input).caseSensitive(this.caseSensitive).project(projectionWithoutConstantAndMetadataFields).createReaderFunc(fileSchema -> GenericOrcReader.buildReader(fileProjection, fileSchema, partition)).split(task.start(), task.length()).filter(task.residual());
                return orc.build();
            }
        }
        throw new IcebergConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("Cannot read %s file: %s", ((DataFile)task.file()).format().name(), ((DataFile)task.file()).path()));
    }

    @Override
    public void close() {
        this.fileIO.close();
    }

    IcebergFileScanTaskReader(FileIO fileIO, Schema tableSchema, Schema projectedSchema, boolean caseSensitive, boolean reuseContainers) {
        this.fileIO = fileIO;
        this.tableSchema = tableSchema;
        this.projectedSchema = projectedSchema;
        this.caseSensitive = caseSensitive;
        this.reuseContainers = reuseContainers;
    }

    public static IcebergFileScanTaskReaderBuilder builder() {
        return new IcebergFileScanTaskReaderBuilder();
    }

    public static class IcebergFileScanTaskReaderBuilder {
        private FileIO fileIO;
        private Schema tableSchema;
        private Schema projectedSchema;
        private boolean caseSensitive;
        private boolean reuseContainers;

        IcebergFileScanTaskReaderBuilder() {
        }

        public IcebergFileScanTaskReaderBuilder fileIO(FileIO fileIO) {
            this.fileIO = fileIO;
            return this;
        }

        public IcebergFileScanTaskReaderBuilder tableSchema(Schema tableSchema) {
            this.tableSchema = tableSchema;
            return this;
        }

        public IcebergFileScanTaskReaderBuilder projectedSchema(Schema projectedSchema) {
            this.projectedSchema = projectedSchema;
            return this;
        }

        public IcebergFileScanTaskReaderBuilder caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public IcebergFileScanTaskReaderBuilder reuseContainers(boolean reuseContainers) {
            this.reuseContainers = reuseContainers;
            return this;
        }

        public IcebergFileScanTaskReader build() {
            return new IcebergFileScanTaskReader(this.fileIO, this.tableSchema, this.projectedSchema, this.caseSensitive, this.reuseContainers);
        }

        public String toString() {
            return "IcebergFileScanTaskReader.IcebergFileScanTaskReaderBuilder(fileIO=" + this.fileIO + ", tableSchema=" + this.tableSchema + ", projectedSchema=" + this.projectedSchema + ", caseSensitive=" + this.caseSensitive + ", reuseContainers=" + this.reuseContainers + ")";
        }
    }
}

