/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.filter.leaf;

import java.util.Arrays;
import java.util.List;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.filter.LeafFilter;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;

class FloatFilters {
    private FloatFilters() {
    }

    static class FloatLessThanEquals
    extends LeafFilter {
        private final double aValue;

        FloatLessThanEquals(String colName, Object aValue, boolean negated) {
            super(colName, negated);
            this.aValue = (Double)aValue;
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            return ((DoubleColumnVector)v).vector[rowIdx] <= this.aValue;
        }
    }

    static class FloatLessThan
    extends LeafFilter {
        private final double aValue;

        FloatLessThan(String colName, Object aValue, boolean negated) {
            super(colName, negated);
            this.aValue = (Double)aValue;
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            return ((DoubleColumnVector)v).vector[rowIdx] < this.aValue;
        }
    }

    static class FloatIn
    extends LeafFilter {
        private final double[] inValues;

        FloatIn(String colName, List<Object> values, boolean negated) {
            super(colName, negated);
            this.inValues = new double[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                this.inValues[i] = (Double)values.get(i);
            }
            Arrays.sort(this.inValues);
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            return Arrays.binarySearch(this.inValues, ((DoubleColumnVector)v).vector[rowIdx]) >= 0;
        }
    }

    static class FloatEquals
    extends LeafFilter {
        private final double aValue;

        FloatEquals(String colName, Object aValue, boolean negated) {
            super(colName, negated);
            this.aValue = (Double)aValue;
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            return ((DoubleColumnVector)v).vector[rowIdx] == this.aValue;
        }
    }

    static class FloatBetween
    extends LeafFilter {
        private final double low;
        private final double high;

        FloatBetween(String colName, Object low, Object high, boolean negated) {
            super(colName, negated);
            this.low = (Double)low;
            this.high = (Double)high;
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            return ((DoubleColumnVector)v).vector[rowIdx] >= this.low && ((DoubleColumnVector)v).vector[rowIdx] <= this.high;
        }
    }
}

