/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.common.type;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class CalendarUtils {
    public static final long SWITCHOVER_MILLIS;
    public static final long SWITCHOVER_DAYS;
    private static final String DATE = "yyyy-MM-dd";
    private static final String TIME = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final TimeZone UTC;
    private static final ThreadLocal<SimpleDateFormat> HYBRID_DATE_FORMAT;
    private static final ThreadLocal<SimpleDateFormat> HYBRID_TIME_FORMAT;
    private static final ThreadLocal<SimpleDateFormat> PROLEPTIC_DATE_FORMAT;
    private static final ThreadLocal<SimpleDateFormat> PROLEPTIC_TIME_FORMAT;

    private static SimpleDateFormat createFormatter(String fmt, boolean proleptic) {
        SimpleDateFormat result = new SimpleDateFormat(fmt);
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        if (proleptic) {
            calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        }
        result.setCalendar(calendar);
        return result;
    }

    public static int convertDateToProleptic(int hybrid) {
        int proleptic = hybrid;
        if ((long)hybrid < SWITCHOVER_DAYS) {
            String dateStr = HYBRID_DATE_FORMAT.get().format(new Date(TimeUnit.DAYS.toMillis(hybrid)));
            try {
                proleptic = (int)TimeUnit.MILLISECONDS.toDays(PROLEPTIC_DATE_FORMAT.get().parse(dateStr).getTime());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Can't parse " + dateStr, e);
            }
        }
        return proleptic;
    }

    public static int convertDateToHybrid(int proleptic) {
        int hyrbid = proleptic;
        if ((long)proleptic < SWITCHOVER_DAYS) {
            String dateStr = PROLEPTIC_DATE_FORMAT.get().format(new Date(TimeUnit.DAYS.toMillis(proleptic)));
            try {
                hyrbid = (int)TimeUnit.MILLISECONDS.toDays(HYBRID_DATE_FORMAT.get().parse(dateStr).getTime());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Can't parse " + dateStr, e);
            }
        }
        return hyrbid;
    }

    public static int convertDate(int original, boolean fromProleptic, boolean toProleptic) {
        if (fromProleptic != toProleptic) {
            return toProleptic ? CalendarUtils.convertDateToProleptic(original) : CalendarUtils.convertDateToHybrid(original);
        }
        return original;
    }

    public static long convertTime(long original, boolean fromProleptic, boolean toProleptic) {
        if (fromProleptic != toProleptic) {
            return toProleptic ? CalendarUtils.convertTimeToProleptic(original) : CalendarUtils.convertTimeToHybrid(original);
        }
        return original;
    }

    public static long convertTimeToProleptic(long hybrid) {
        long proleptic = hybrid;
        if (hybrid < SWITCHOVER_MILLIS) {
            String dateStr = HYBRID_TIME_FORMAT.get().format(new Date(hybrid));
            try {
                proleptic = PROLEPTIC_TIME_FORMAT.get().parse(dateStr).getTime();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Can't parse " + dateStr, e);
            }
        }
        return proleptic;
    }

    public static long convertTimeToHybrid(long proleptic) {
        long hybrid = proleptic;
        if (proleptic < SWITCHOVER_MILLIS) {
            String dateStr = PROLEPTIC_TIME_FORMAT.get().format(new Date(proleptic));
            try {
                hybrid = HYBRID_TIME_FORMAT.get().parse(dateStr).getTime();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Can't parse " + dateStr, e);
            }
        }
        return hybrid;
    }

    public static String formatDate(long epochDay, boolean useProleptic) {
        long millis = TimeUnit.DAYS.toMillis(epochDay);
        return useProleptic ? PROLEPTIC_DATE_FORMAT.get().format(millis) : HYBRID_DATE_FORMAT.get().format(millis);
    }

    public static String formatTimestamp(long epochMillis, boolean useProleptic) {
        Date date = new Date(epochMillis);
        return useProleptic ? PROLEPTIC_TIME_FORMAT.get().format(date) : HYBRID_TIME_FORMAT.get().format(date);
    }

    private CalendarUtils() {
        throw new UnsupportedOperationException();
    }

    static {
        UTC = TimeZone.getTimeZone("UTC");
        HYBRID_DATE_FORMAT = ThreadLocal.withInitial(() -> CalendarUtils.createFormatter(DATE, false));
        HYBRID_TIME_FORMAT = ThreadLocal.withInitial(() -> CalendarUtils.createFormatter(TIME, false));
        PROLEPTIC_DATE_FORMAT = ThreadLocal.withInitial(() -> CalendarUtils.createFormatter(DATE, true));
        PROLEPTIC_TIME_FORMAT = ThreadLocal.withInitial(() -> CalendarUtils.createFormatter(TIME, true));
        try {
            SWITCHOVER_MILLIS = HYBRID_DATE_FORMAT.get().parse("1582-10-15").getTime();
            SWITCHOVER_DAYS = TimeUnit.MILLISECONDS.toDays(SWITCHOVER_MILLIS);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Can't parse switch over date", e);
        }
    }
}

