/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.metrics.ScanMetrics;
import org.apache.iceberg.metrics.ScanMetricsUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.ListMultimap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Multimaps;
import org.apache.iceberg.relocated.com.google.common.collect.ObjectArrays;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.PartitionSet;
import org.apache.iceberg.util.StructLikeWrapper;
import org.apache.iceberg.util.Tasks;

class DeleteFileIndex {
    private static final DeleteFile[] NO_DELETES = new DeleteFile[0];
    private final Map<Integer, Types.StructType> partitionTypeById;
    private final Map<Integer, ThreadLocal<StructLikeWrapper>> wrapperById;
    private final DeleteFileGroup globalDeletes;
    private final Map<Pair<Integer, StructLikeWrapper>, DeleteFileGroup> deletesByPartition;
    private final boolean isEmpty;
    private final boolean useColumnStatsFiltering;

    @Deprecated
    DeleteFileIndex(Map<Integer, PartitionSpec> specs, long[] globalSeqs, DeleteFile[] globalDeletes, Map<Pair<Integer, StructLikeWrapper>, Pair<long[], DeleteFile[]>> deletesByPartition) {
        this(specs, DeleteFileIndex.index(specs, globalSeqs, globalDeletes), DeleteFileIndex.index(specs, deletesByPartition), true);
    }

    private DeleteFileIndex(Map<Integer, PartitionSpec> specs, DeleteFileGroup globalDeletes, Map<Pair<Integer, StructLikeWrapper>, DeleteFileGroup> deletesByPartition, boolean useColumnStatsFiltering) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        specs.forEach((specId, spec) -> builder.put(specId, spec.partitionType()));
        this.partitionTypeById = builder.build();
        this.wrapperById = this.wrappers(specs);
        this.globalDeletes = globalDeletes;
        this.deletesByPartition = deletesByPartition;
        this.isEmpty = globalDeletes == null && deletesByPartition.isEmpty();
        this.useColumnStatsFiltering = useColumnStatsFiltering;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public Iterable<DeleteFile> referencedDeleteFiles() {
        Iterable<Object> deleteFiles = Collections.emptyList();
        if (this.globalDeletes != null) {
            deleteFiles = Iterables.concat(deleteFiles, this.globalDeletes.referencedDeleteFiles());
        }
        for (DeleteFileGroup partitionDeletes : this.deletesByPartition.values()) {
            deleteFiles = Iterables.concat(deleteFiles, partitionDeletes.referencedDeleteFiles());
        }
        return deleteFiles;
    }

    private Map<Integer, ThreadLocal<StructLikeWrapper>> wrappers(Map<Integer, PartitionSpec> specs) {
        HashMap<Integer, ThreadLocal<StructLikeWrapper>> wrappers = Maps.newHashMap();
        specs.forEach((specId, spec) -> wrappers.put((Integer)specId, this.newWrapper((int)specId)));
        return wrappers;
    }

    private ThreadLocal<StructLikeWrapper> newWrapper(int specId) {
        return ThreadLocal.withInitial(() -> StructLikeWrapper.forType(this.partitionTypeById.get(specId)));
    }

    private Pair<Integer, StructLikeWrapper> partition(int specId, StructLike struct) {
        ThreadLocal<StructLikeWrapper> wrapper = this.wrapperById.get(specId);
        return Pair.of(specId, wrapper.get().set(struct));
    }

    DeleteFile[] forEntry(ManifestEntry<DataFile> entry) {
        return this.forDataFile(entry.dataSequenceNumber(), entry.file());
    }

    DeleteFile[] forDataFile(DataFile file) {
        return this.forDataFile(file.dataSequenceNumber(), file);
    }

    DeleteFile[] forDataFile(long sequenceNumber, DataFile file) {
        if (this.isEmpty) {
            return NO_DELETES;
        }
        Pair<Integer, StructLikeWrapper> partition = this.partition(file.specId(), file.partition());
        DeleteFileGroup partitionDeletes = this.deletesByPartition.get(partition);
        if (this.globalDeletes == null && partitionDeletes == null) {
            return NO_DELETES;
        }
        if (this.useColumnStatsFiltering) {
            return this.limitWithColumnStatsFiltering(sequenceNumber, file, partitionDeletes);
        }
        return this.limitWithoutColumnStatsFiltering(sequenceNumber, partitionDeletes);
    }

    private DeleteFile[] limitWithColumnStatsFiltering(long sequenceNumber, DataFile file, DeleteFileGroup partitionDeletes) {
        Stream<IndexedDeleteFile> matchingDeletes;
        if (partitionDeletes == null) {
            matchingDeletes = this.globalDeletes.limit(sequenceNumber);
        } else if (this.globalDeletes == null) {
            matchingDeletes = partitionDeletes.limit(sequenceNumber);
        } else {
            Stream<IndexedDeleteFile> matchingGlobalDeletes = this.globalDeletes.limit(sequenceNumber);
            Stream<IndexedDeleteFile> matchingPartitionDeletes = partitionDeletes.limit(sequenceNumber);
            matchingDeletes = Stream.concat(matchingGlobalDeletes, matchingPartitionDeletes);
        }
        return (DeleteFile[])matchingDeletes.filter(deleteFile -> DeleteFileIndex.canContainDeletesForFile(file, deleteFile)).map(IndexedDeleteFile::wrapped).toArray(DeleteFile[]::new);
    }

    private DeleteFile[] limitWithoutColumnStatsFiltering(long sequenceNumber, DeleteFileGroup partitionDeletes) {
        if (partitionDeletes == null) {
            return this.globalDeletes.filter(sequenceNumber);
        }
        if (this.globalDeletes == null) {
            return partitionDeletes.filter(sequenceNumber);
        }
        DeleteFile[] matchingGlobalDeletes = this.globalDeletes.filter(sequenceNumber);
        DeleteFile[] matchingPartitionDeletes = partitionDeletes.filter(sequenceNumber);
        return ObjectArrays.concat(matchingGlobalDeletes, matchingPartitionDeletes, DeleteFile.class);
    }

    private static boolean canContainDeletesForFile(DataFile dataFile, IndexedDeleteFile deleteFile) {
        switch (deleteFile.content()) {
            case POSITION_DELETES: {
                return DeleteFileIndex.canContainPosDeletesForFile(dataFile, deleteFile);
            }
            case EQUALITY_DELETES: {
                return DeleteFileIndex.canContainEqDeletesForFile(dataFile, deleteFile, deleteFile.spec().schema());
            }
        }
        return true;
    }

    private static boolean canContainPosDeletesForFile(DataFile dataFile, IndexedDeleteFile deleteFile) {
        if (deleteFile.hasNoLowerOrUpperBounds()) {
            return true;
        }
        int pathId = MetadataColumns.DELETE_FILE_PATH.fieldId();
        Comparator<CharSequence> comparator = Comparators.charSequences();
        CharSequence lower = (CharSequence)deleteFile.lowerBound(pathId);
        if (lower != null && comparator.compare(dataFile.path(), lower) < 0) {
            return false;
        }
        CharSequence upper = (CharSequence)deleteFile.upperBound(pathId);
        return upper == null || comparator.compare(dataFile.path(), upper) <= 0;
    }

    private static boolean canContainEqDeletesForFile(DataFile dataFile, IndexedDeleteFile deleteFile, Schema schema) {
        Map<Integer, ByteBuffer> dataLowers = dataFile.lowerBounds();
        Map<Integer, ByteBuffer> dataUppers = dataFile.upperBounds();
        boolean checkRanges = dataLowers != null && dataUppers != null && deleteFile.hasLowerAndUpperBounds();
        Map<Integer, Long> dataNullCounts = dataFile.nullValueCounts();
        Map<Integer, Long> dataValueCounts = dataFile.valueCounts();
        Map<Integer, Long> deleteNullCounts = deleteFile.nullValueCounts();
        Map<Integer, Long> deleteValueCounts = deleteFile.valueCounts();
        for (int id : deleteFile.equalityFieldIds()) {
            Types.NestedField field = schema.findField(id);
            if (!field.type().isPrimitiveType() || DeleteFileIndex.containsNull(dataNullCounts, field) && DeleteFileIndex.containsNull(deleteNullCounts, field)) continue;
            if (DeleteFileIndex.allNull(dataNullCounts, dataValueCounts, field) && DeleteFileIndex.allNonNull(deleteNullCounts, field)) {
                return false;
            }
            if (DeleteFileIndex.allNull(deleteNullCounts, deleteValueCounts, field) && DeleteFileIndex.allNonNull(dataNullCounts, field)) {
                return false;
            }
            if (!checkRanges) continue;
            ByteBuffer dataLower = dataLowers.get(id);
            ByteBuffer dataUpper = dataUppers.get(id);
            Object deleteLower = deleteFile.lowerBound(id);
            Object deleteUpper = deleteFile.upperBound(id);
            if (dataLower == null || dataUpper == null || deleteLower == null || deleteUpper == null || DeleteFileIndex.rangesOverlap(field, dataLower, dataUpper, deleteLower, deleteUpper)) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean rangesOverlap(Types.NestedField field, ByteBuffer dataLowerBuf, ByteBuffer dataUpperBuf, T deleteLower, T deleteUpper) {
        Object dataLower;
        Type.PrimitiveType type = field.type().asPrimitiveType();
        Comparator<T> comparator = Comparators.forType(type);
        if (comparator.compare(dataLower = Conversions.fromByteBuffer(type, dataLowerBuf), deleteUpper) > 0) {
            return false;
        }
        Object dataUpper = Conversions.fromByteBuffer(type, dataUpperBuf);
        return comparator.compare(deleteLower, dataUpper) <= 0;
    }

    private static boolean allNonNull(Map<Integer, Long> nullValueCounts, Types.NestedField field) {
        if (field.isRequired()) {
            return true;
        }
        if (nullValueCounts == null) {
            return false;
        }
        Long nullValueCount = nullValueCounts.get(field.fieldId());
        if (nullValueCount == null) {
            return false;
        }
        return nullValueCount <= 0L;
    }

    private static boolean allNull(Map<Integer, Long> nullValueCounts, Map<Integer, Long> valueCounts, Types.NestedField field) {
        if (field.isRequired()) {
            return false;
        }
        if (nullValueCounts == null || valueCounts == null) {
            return false;
        }
        Long nullValueCount = nullValueCounts.get(field.fieldId());
        Long valueCount = valueCounts.get(field.fieldId());
        if (nullValueCount == null || valueCount == null) {
            return false;
        }
        return nullValueCount.equals(valueCount);
    }

    private static boolean containsNull(Map<Integer, Long> nullValueCounts, Types.NestedField field) {
        if (field.isRequired()) {
            return false;
        }
        if (nullValueCounts == null) {
            return true;
        }
        Long nullValueCount = nullValueCounts.get(field.fieldId());
        if (nullValueCount == null) {
            return true;
        }
        return nullValueCount > 0L;
    }

    private static DeleteFileGroup index(Map<Integer, PartitionSpec> specs, Pair<long[], DeleteFile[]> pairs) {
        return DeleteFileIndex.index(specs, pairs.first(), pairs.second());
    }

    private static DeleteFileGroup index(Map<Integer, PartitionSpec> specs, long[] seqs, DeleteFile[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        IndexedDeleteFile[] indexedGlobalDeleteFiles = new IndexedDeleteFile[files.length];
        for (int pos = 0; pos < files.length; ++pos) {
            DeleteFile file = files[pos];
            PartitionSpec spec = specs.get(file.specId());
            long applySequenceNumber = seqs[pos];
            indexedGlobalDeleteFiles[pos] = new IndexedDeleteFile(spec, file, applySequenceNumber);
        }
        return new DeleteFileGroup(seqs, indexedGlobalDeleteFiles);
    }

    private static Map<Pair<Integer, StructLikeWrapper>, DeleteFileGroup> index(Map<Integer, PartitionSpec> specs, Map<Pair<Integer, StructLikeWrapper>, Pair<long[], DeleteFile[]>> deletesByPartition) {
        HashMap<Pair<Integer, StructLikeWrapper>, DeleteFileGroup> indexed = Maps.newHashMap();
        deletesByPartition.forEach((key, value) -> indexed.put((Pair<Integer, StructLikeWrapper>)key, DeleteFileIndex.index(specs, value)));
        return indexed;
    }

    static Builder builderFor(FileIO io, Iterable<ManifestFile> deleteManifests) {
        return new Builder(io, Sets.newHashSet(deleteManifests));
    }

    static Builder builderFor(Iterable<DeleteFile> deleteFiles) {
        return new Builder(deleteFiles);
    }

    private static class IndexedDeleteFile {
        private final PartitionSpec spec;
        private final DeleteFile wrapped;
        private final long applySequenceNumber;
        private volatile Map<Integer, Object> convertedLowerBounds = null;
        private volatile Map<Integer, Object> convertedUpperBounds = null;

        IndexedDeleteFile(PartitionSpec spec, DeleteFile file, long applySequenceNumber) {
            this.spec = spec;
            this.wrapped = file;
            this.applySequenceNumber = applySequenceNumber;
        }

        IndexedDeleteFile(PartitionSpec spec, DeleteFile file) {
            this.spec = spec;
            this.wrapped = file;
            this.applySequenceNumber = file.content() == FileContent.EQUALITY_DELETES ? file.dataSequenceNumber() - 1L : file.dataSequenceNumber();
        }

        public PartitionSpec spec() {
            return this.spec;
        }

        public DeleteFile wrapped() {
            return this.wrapped;
        }

        public long applySequenceNumber() {
            return this.applySequenceNumber;
        }

        public FileContent content() {
            return this.wrapped.content();
        }

        public List<Integer> equalityFieldIds() {
            return this.wrapped.equalityFieldIds();
        }

        public Map<Integer, Long> valueCounts() {
            return this.wrapped.valueCounts();
        }

        public Map<Integer, Long> nullValueCounts() {
            return this.wrapped.nullValueCounts();
        }

        public Map<Integer, Long> nanValueCounts() {
            return this.wrapped.nanValueCounts();
        }

        public boolean hasNoLowerOrUpperBounds() {
            return this.wrapped.lowerBounds() == null || this.wrapped.upperBounds() == null;
        }

        public boolean hasLowerAndUpperBounds() {
            return this.wrapped.lowerBounds() != null && this.wrapped.upperBounds() != null;
        }

        public <T> T lowerBound(int id) {
            return (T)this.lowerBounds().get(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Integer, Object> lowerBounds() {
            if (this.convertedLowerBounds == null) {
                IndexedDeleteFile indexedDeleteFile = this;
                synchronized (indexedDeleteFile) {
                    if (this.convertedLowerBounds == null) {
                        this.convertedLowerBounds = this.convertBounds(this.wrapped.lowerBounds());
                    }
                }
            }
            return this.convertedLowerBounds;
        }

        public <T> T upperBound(int id) {
            return (T)this.upperBounds().get(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Integer, Object> upperBounds() {
            if (this.convertedUpperBounds == null) {
                IndexedDeleteFile indexedDeleteFile = this;
                synchronized (indexedDeleteFile) {
                    if (this.convertedUpperBounds == null) {
                        this.convertedUpperBounds = this.convertBounds(this.wrapped.upperBounds());
                    }
                }
            }
            return this.convertedUpperBounds;
        }

        private Map<Integer, Object> convertBounds(Map<Integer, ByteBuffer> bounds) {
            HashMap<Integer, Object> converted = Maps.newHashMap();
            if (bounds != null) {
                if (this.wrapped.content() == FileContent.POSITION_DELETES) {
                    Type pathType = MetadataColumns.DELETE_FILE_PATH.type();
                    int pathId = MetadataColumns.DELETE_FILE_PATH.fieldId();
                    ByteBuffer bound = bounds.get(pathId);
                    if (bound != null) {
                        converted.put(pathId, Conversions.fromByteBuffer(pathType, bound));
                    }
                } else {
                    for (int id : this.equalityFieldIds()) {
                        ByteBuffer bound;
                        Type type = this.spec.schema().findField(id).type();
                        if (!type.isPrimitiveType() || (bound = bounds.get(id)) == null) continue;
                        converted.put(id, Conversions.fromByteBuffer(type, bound));
                    }
                }
            }
            return converted;
        }
    }

    private static class DeleteFileGroup {
        private final long[] seqs;
        private final IndexedDeleteFile[] files;

        DeleteFileGroup(IndexedDeleteFile[] files) {
            this.seqs = Arrays.stream(files).mapToLong(IndexedDeleteFile::applySequenceNumber).toArray();
            this.files = files;
        }

        DeleteFileGroup(long[] seqs, IndexedDeleteFile[] files) {
            this.seqs = seqs;
            this.files = files;
        }

        public DeleteFile[] filter(long seq) {
            int start = this.findStartIndex(seq);
            if (start >= this.files.length) {
                return NO_DELETES;
            }
            DeleteFile[] matchingFiles = new DeleteFile[this.files.length - start];
            for (int index = start; index < this.files.length; ++index) {
                matchingFiles[index - start] = this.files[index].wrapped();
            }
            return matchingFiles;
        }

        public Stream<IndexedDeleteFile> limit(long seq) {
            int start = this.findStartIndex(seq);
            return Arrays.stream(this.files, start, this.files.length);
        }

        private int findStartIndex(long seq) {
            int start;
            int pos = Arrays.binarySearch(this.seqs, seq);
            if (pos < 0) {
                start = -(pos + 1);
            } else {
                for (start = pos; start > 0 && this.seqs[start - 1] >= seq; --start) {
                }
            }
            return start;
        }

        public Iterable<DeleteFile> referencedDeleteFiles() {
            return Arrays.stream(this.files).map(IndexedDeleteFile::wrapped).collect(Collectors.toList());
        }
    }

    static class Builder {
        private final FileIO io;
        private final Set<ManifestFile> deleteManifests;
        private final Iterable<DeleteFile> deleteFiles;
        private long minSequenceNumber = 0L;
        private Map<Integer, PartitionSpec> specsById = null;
        private Expression dataFilter = Expressions.alwaysTrue();
        private Expression partitionFilter = Expressions.alwaysTrue();
        private PartitionSet partitionSet = null;
        private boolean caseSensitive = true;
        private ExecutorService executorService = null;
        private ScanMetrics scanMetrics = ScanMetrics.noop();

        Builder(FileIO io, Set<ManifestFile> deleteManifests) {
            this.io = io;
            this.deleteManifests = Sets.newHashSet(deleteManifests);
            this.deleteFiles = null;
        }

        Builder(Iterable<DeleteFile> deleteFiles) {
            this.io = null;
            this.deleteManifests = null;
            this.deleteFiles = deleteFiles;
        }

        Builder afterSequenceNumber(long seq) {
            this.minSequenceNumber = seq;
            return this;
        }

        Builder specsById(Map<Integer, PartitionSpec> newSpecsById) {
            this.specsById = newSpecsById;
            return this;
        }

        Builder filterData(Expression newDataFilter) {
            Preconditions.checkArgument(this.deleteFiles == null, "Index constructed from files does not support data filters");
            this.dataFilter = Expressions.and(this.dataFilter, newDataFilter);
            return this;
        }

        Builder filterPartitions(Expression newPartitionFilter) {
            Preconditions.checkArgument(this.deleteFiles == null, "Index constructed from files does not support partition filters");
            this.partitionFilter = Expressions.and(this.partitionFilter, newPartitionFilter);
            return this;
        }

        Builder filterPartitions(PartitionSet newPartitionSet) {
            Preconditions.checkArgument(this.deleteFiles == null, "Index constructed from files does not support partition filters");
            this.partitionSet = newPartitionSet;
            return this;
        }

        Builder caseSensitive(boolean newCaseSensitive) {
            this.caseSensitive = newCaseSensitive;
            return this;
        }

        Builder planWith(ExecutorService newExecutorService) {
            this.executorService = newExecutorService;
            return this;
        }

        Builder scanMetrics(ScanMetrics newScanMetrics) {
            this.scanMetrics = newScanMetrics;
            return this;
        }

        private Iterable<DeleteFile> filterDeleteFiles() {
            return Iterables.filter(this.deleteFiles, file -> file.dataSequenceNumber() > this.minSequenceNumber);
        }

        private Collection<DeleteFile> loadDeleteFiles() {
            ConcurrentLinkedQueue<DeleteFile> files = new ConcurrentLinkedQueue<DeleteFile>();
            Tasks.foreach(this.deleteManifestReaders()).stopOnFailure().throwFailureWhenFinished().executeWith(this.executorService).run(deleteFile -> {
                try (CloseableIterable reader = deleteFile;){
                    for (ManifestEntry entry : reader) {
                        if (entry.dataSequenceNumber() <= this.minSequenceNumber) continue;
                        files.add((DeleteFile)((DeleteFile)entry.file()).copy());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e, "Failed to close", new Object[0]);
                }
            });
            return files;
        }

        DeleteFileIndex build() {
            Iterable<DeleteFile> files = this.deleteFiles != null ? this.filterDeleteFiles() : this.loadDeleteFiles();
            boolean useColumnStatsFiltering = false;
            HashMap<Integer, StructLikeWrapper> wrappersBySpecId = Maps.newHashMap();
            ListMultimap<Pair<Integer, StructLikeWrapper>, IndexedDeleteFile> deleteFilesByPartition = Multimaps.newListMultimap(Maps.newHashMap(), Lists::newArrayList);
            for (DeleteFile file2 : files) {
                int specId = file2.specId();
                PartitionSpec spec = this.specsById.get(specId);
                StructLikeWrapper wrapper = wrappersBySpecId.computeIfAbsent(specId, id -> StructLikeWrapper.forType(spec.partitionType())).copyFor(file2.partition());
                IndexedDeleteFile indexedFile = new IndexedDeleteFile(spec, file2);
                deleteFilesByPartition.put(Pair.of(specId, wrapper), indexedFile);
                if (!useColumnStatsFiltering) {
                    useColumnStatsFiltering = indexedFile.hasLowerAndUpperBounds();
                }
                ScanMetricsUtil.indexedDeleteFile(this.scanMetrics, file2);
            }
            HashMap<Pair, DeleteFileGroup> sortedDeletesByPartition = Maps.newHashMap();
            DeleteFileGroup globalDeletes = null;
            for (Pair partition : deleteFilesByPartition.keySet()) {
                if (this.specsById.get(partition.first()).isUnpartitioned()) {
                    Preconditions.checkState(globalDeletes == null, "Detected multiple partition specs with no partitions");
                    IndexedDeleteFile[] eqFilesSortedBySeq = (IndexedDeleteFile[])deleteFilesByPartition.get((Object)partition).stream().filter(file -> file.content() == FileContent.EQUALITY_DELETES).sorted(Comparator.comparingLong(IndexedDeleteFile::applySequenceNumber)).toArray(IndexedDeleteFile[]::new);
                    if (eqFilesSortedBySeq.length > 0) {
                        globalDeletes = new DeleteFileGroup(eqFilesSortedBySeq);
                    }
                    IndexedDeleteFile[] posFilesSortedBySeq = (IndexedDeleteFile[])deleteFilesByPartition.get((Object)partition).stream().filter(file -> file.content() == FileContent.POSITION_DELETES).sorted(Comparator.comparingLong(IndexedDeleteFile::applySequenceNumber)).toArray(IndexedDeleteFile[]::new);
                    sortedDeletesByPartition.put(partition, new DeleteFileGroup(posFilesSortedBySeq));
                    continue;
                }
                IndexedDeleteFile[] filesSortedBySeq = (IndexedDeleteFile[])deleteFilesByPartition.get((Object)partition).stream().sorted(Comparator.comparingLong(IndexedDeleteFile::applySequenceNumber)).toArray(IndexedDeleteFile[]::new);
                sortedDeletesByPartition.put(partition, new DeleteFileGroup(filesSortedBySeq));
            }
            return new DeleteFileIndex(this.specsById, globalDeletes, sortedDeletesByPartition, useColumnStatsFiltering);
        }

        private Iterable<CloseableIterable<ManifestEntry<DeleteFile>>> deleteManifestReaders() {
            LoadingCache<Integer, ManifestEvaluator> evalCache = this.specsById == null ? null : Caffeine.newBuilder().build(specId -> {
                PartitionSpec spec = this.specsById.get(specId);
                return ManifestEvaluator.forPartitionFilter(Expressions.and(this.partitionFilter, Projections.inclusive(spec, this.caseSensitive).project(this.dataFilter)), spec, this.caseSensitive);
            });
            CloseableIterable<ManifestFile> closeableDeleteManifests = CloseableIterable.withNoopClose(this.deleteManifests);
            CloseableIterable<ManifestFile> matchingManifests = evalCache == null ? closeableDeleteManifests : CloseableIterable.filter(this.scanMetrics.skippedDeleteManifests(), closeableDeleteManifests, manifest -> manifest.content() == ManifestContent.DELETES && (manifest.hasAddedFiles() || manifest.hasExistingFiles()) && ((ManifestEvaluator)evalCache.get(manifest.partitionSpecId())).eval((ManifestFile)manifest));
            matchingManifests = CloseableIterable.count(this.scanMetrics.scannedDeleteManifests(), matchingManifests);
            return Iterables.transform(matchingManifests, manifest -> ManifestFiles.readDeleteManifest(manifest, this.io, this.specsById).filterRows(this.dataFilter).filterPartitions(this.partitionFilter).filterPartitions(this.partitionSet).caseSensitive(this.caseSensitive).scanMetrics(this.scanMetrics).liveEntries());
        }
    }
}

