/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.common.DynClasses;
import org.apache.iceberg.common.DynMethods;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.CommonConfig;
import org.apache.seatunnel.shade.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergCatalogLoader
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(IcebergCatalogLoader.class);
    private static final long serialVersionUID = -6003040601422350869L;
    private static final List<String> HADOOP_CONF_FILES = ImmutableList.of((Object)"core-site.xml", (Object)"hdfs-site.xml", (Object)"hive-site.xml");
    private CommonConfig config;

    public IcebergCatalogLoader(CommonConfig config) {
        this.config = config;
    }

    public Catalog loadCatalog() {
        Thread.currentThread().setContextClassLoader(IcebergCatalogLoader.class.getClassLoader());
        return CatalogUtil.buildIcebergCatalog(this.config.getCatalogName(), this.config.getCatalogProps(), this.loadHadoopConfig(this.config));
    }

    private Object loadHadoopConfig(CommonConfig config) {
        Class configClass = DynClasses.builder().impl("org.apache.hadoop.hdfs.HdfsConfiguration").orNull().build();
        if (configClass == null) {
            configClass = DynClasses.builder().impl("org.apache.hadoop.conf.Configuration").orNull().build();
        }
        if (configClass == null) {
            log.info("Hadoop not found on classpath, not creating Hadoop config");
            return null;
        }
        try {
            Object result = configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DynMethods.BoundMethod addResourceMethod = DynMethods.builder("addResource").impl(configClass, URL.class).build(result);
            DynMethods.BoundMethod setMethod = DynMethods.builder("set").impl(configClass, String.class, String.class).build(result);
            String hadoopConfPath = config.getHadoopConfPath();
            if (hadoopConfPath != null) {
                HADOOP_CONF_FILES.forEach(confFile -> {
                    Path path = Paths.get(hadoopConfPath, confFile);
                    if (Files.exists(path, new LinkOption[0])) {
                        try {
                            addResourceMethod.invoke(path.toUri().toURL());
                        }
                        catch (IOException e) {
                            log.warn("Error adding Hadoop resource {}, resource was not added", (Object)path, (Object)e);
                        }
                    }
                });
            }
            config.getHadoopProps().forEach((xva$0, xva$1) -> setMethod.invoke(xva$0, xva$1));
            log.info("Hadoop config initialized: {}", (Object)configClass.getName());
            return result;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("Hadoop found on classpath but could not create config, proceeding without config", (Throwable)e);
            return null;
        }
    }
}

