/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.catalog;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.types.Types;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.InfoPreviewResult;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.PreviewResult;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.connectors.seatunnel.iceberg.IcebergCatalogLoader;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.CommonConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.utils.SchemaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergCatalog
implements Catalog {
    private static final Logger log = LoggerFactory.getLogger(IcebergCatalog.class);
    private String catalogName;
    private ReadonlyConfig readonlyConfig;
    private IcebergCatalogLoader icebergCatalogLoader;
    private org.apache.iceberg.catalog.Catalog catalog;

    public IcebergCatalog(String catalogName, ReadonlyConfig readonlyConfig) {
        this.readonlyConfig = readonlyConfig;
        this.catalogName = catalogName;
        this.icebergCatalogLoader = new IcebergCatalogLoader(new CommonConfig(readonlyConfig));
    }

    public String name() {
        return this.catalogName;
    }

    public void open() throws CatalogException {
        this.catalog = this.icebergCatalogLoader.loadCatalog();
    }

    public void close() throws CatalogException {
        if (this.catalog != null && this.catalog instanceof Closeable) {
            try {
                ((Closeable)((Object)this.catalog)).close();
            }
            catch (IOException e) {
                log.error("Error while closing IcebergCatalog.", (Throwable)e);
                throw new CatalogException((Throwable)e);
            }
        }
    }

    public String getDefaultDatabase() throws CatalogException {
        return "default";
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        if (this.catalog instanceof SupportsNamespaces) {
            boolean exists = ((SupportsNamespaces)((Object)this.catalog)).namespaceExists(Namespace.of(databaseName));
            log.info("Database {} existence status: {}", (Object)databaseName, (Object)exists);
            return exists;
        }
        throw new UnsupportedOperationException("catalog not implements SupportsNamespaces so can't check database exists");
    }

    public List<String> listDatabases() throws CatalogException {
        if (this.catalog instanceof SupportsNamespaces) {
            List<String> databases = ((SupportsNamespaces)((Object)this.catalog)).listNamespaces().stream().map(Namespace::toString).collect(Collectors.toList());
            log.info("Fetched {} namespaces.", (Object)databases.size());
            return databases;
        }
        throw new UnsupportedOperationException("catalog not implements SupportsNamespaces so can't list databases");
    }

    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        List<String> tables = this.catalog.listTables(Namespace.of(databaseName)).stream().map(tableIdentifier -> SchemaUtils.toTablePath(tableIdentifier).getTableName()).collect(Collectors.toList());
        log.info("Fetched {} tables.", (Object)tables.size());
        return tables;
    }

    public boolean tableExists(TablePath tablePath) throws CatalogException {
        return this.catalog.tableExists(SchemaUtils.toIcebergTableIdentifier(tablePath));
    }

    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        TableIdentifier icebergTableIdentifier = SchemaUtils.toIcebergTableIdentifier(tablePath);
        try {
            CatalogTable catalogTable = this.toCatalogTable(this.catalog.loadTable(icebergTableIdentifier), tablePath);
            log.info("Fetched table details for: {}", (Object)tablePath);
            return catalogTable;
        }
        catch (NoSuchTableException e) {
            throw new TableNotExistException("Table not exist", tablePath, (Throwable)e);
        }
    }

    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        log.info("Creating table at path: {}", (Object)tablePath);
        SchemaUtils.autoCreateTable(this.catalog, tablePath, table, this.readonlyConfig);
    }

    public void dropTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        if (ignoreIfNotExists && !this.tableExists(tablePath)) {
            log.info("Attempted to drop table at path: {}. The table does not exist, but proceeding as 'ignoreIfNotExists' is set to true.", (Object)tablePath);
            return;
        }
        this.catalog.dropTable(SchemaUtils.toIcebergTableIdentifier(tablePath), true);
        log.info("Dropped table at path: {}", (Object)tablePath);
    }

    public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
    }

    public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
    }

    public boolean isExistsData(TablePath tablePath) {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException("table not exist", tablePath);
        }
        TableIdentifier icebergTableIdentifier = SchemaUtils.toIcebergTableIdentifier(tablePath);
        Snapshot snapshot = this.catalog.loadTable(icebergTableIdentifier).currentSnapshot();
        if (snapshot != null) {
            String total = snapshot.summary().getOrDefault("total-records", null);
            return total != null && !total.equals("0");
        }
        return false;
    }

    public void executeSql(TablePath tablePath, String sql) {
        throw new UnsupportedOperationException("Does not support executing custom SQL");
    }

    public void truncateTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException("table not exist", tablePath);
        }
        TableIdentifier icebergTableIdentifier = SchemaUtils.toIcebergTableIdentifier(tablePath);
        this.catalog.loadTable(icebergTableIdentifier).newDelete().deleteFromRowFilter(Expressions.alwaysTrue()).commit();
        log.info("Truncated table at path: {}", (Object)tablePath);
    }

    public CatalogTable toCatalogTable(Table icebergTable, TablePath tablePath) {
        List<Types.NestedField> columns = icebergTable.schema().columns();
        TableSchema.Builder builder = TableSchema.builder();
        columns.stream().forEach(nestedField -> {
            String name = nestedField.name();
            SeaTunnelDataType<?> seaTunnelType = SchemaUtils.toSeaTunnelType(name, nestedField.type());
            PhysicalColumn physicalColumn = PhysicalColumn.of((String)name, seaTunnelType, (Long)null, (boolean)true, null, (String)nestedField.doc());
            builder.column((Column)physicalColumn);
        });
        List partitionKeys = icebergTable.spec().fields().stream().map(PartitionField::name).collect(Collectors.toList());
        return CatalogTable.of((org.apache.seatunnel.api.table.catalog.TableIdentifier)org.apache.seatunnel.api.table.catalog.TableIdentifier.of((String)this.catalogName, (String)tablePath.getDatabaseName(), (String)tablePath.getTableName()), (TableSchema)builder.build(), icebergTable.properties(), partitionKeys, null, (String)this.catalogName);
    }

    public PreviewResult previewAction(Catalog.ActionType actionType, TablePath tablePath, Optional<CatalogTable> catalogTable) {
        if (actionType == Catalog.ActionType.CREATE_TABLE) {
            Preconditions.checkArgument((boolean)catalogTable.isPresent(), (Object)"CatalogTable cannot be null");
            return new InfoPreviewResult("create table " + SchemaUtils.toIcebergTableIdentifier(tablePath));
        }
        if (actionType == Catalog.ActionType.DROP_TABLE) {
            return new InfoPreviewResult("drop table " + SchemaUtils.toIcebergTableIdentifier(tablePath));
        }
        if (actionType == Catalog.ActionType.TRUNCATE_TABLE) {
            return new InfoPreviewResult("truncate table " + SchemaUtils.toIcebergTableIdentifier(tablePath));
        }
        if (actionType == Catalog.ActionType.CREATE_DATABASE) {
            return new InfoPreviewResult("do nothing");
        }
        if (actionType == Catalog.ActionType.DROP_DATABASE) {
            return new InfoPreviewResult("do nothing");
        }
        throw new UnsupportedOperationException("Unsupported action type: " + actionType);
    }
}

