/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.CommonConfig;
import org.apache.seatunnel.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.seatunnel.shade.com.google.common.collect.ImmutableList;

public class SinkConfig
extends CommonConfig {
    public static final int SCHEMA_UPDATE_RETRIES = 2;
    public static final int CREATE_TABLE_RETRIES = 2;
    private static final String ID_COLUMNS = "id-columns";
    private static final String PARTITION_BY = "partition-by";
    public static final Option<Map<String, String>> TABLE_PROPS = Options.key((String)"iceberg.table.config").mapType().defaultValue(new HashMap()).withDescription("Iceberg table configs");
    public static final Option<Map<String, String>> WRITE_PROPS = Options.key((String)"iceberg.table.write-props").mapType().defaultValue(new HashMap()).withDescription("Properties passed through to Iceberg writer initialization, these take precedence, such as 'write.format.default', 'write.target-file-size-bytes', and other settings, can be found with specific parameters at 'https://github.com/apache/iceberg/blob/main/core/src/main/java/org/apache/iceberg/TableProperties.java'.");
    public static final Option<Map<String, String>> AUTO_CREATE_PROPS = Options.key((String)"iceberg.table.auto-create-props").mapType().defaultValue(new HashMap()).withDescription("Configuration specified by Iceberg during automatic table creation.");
    public static final Option<Boolean> TABLE_SCHEMA_EVOLUTION_ENABLED_PROP = Options.key((String)"iceberg.table.schema-evolution-enabled").booleanType().defaultValue((Object)false).withDescription("Setting to true enables Iceberg tables to support schema evolution during the synchronization process");
    public static final Option<String> TABLE_PRIMARY_KEYS = Options.key((String)"iceberg.table.primary-keys").stringType().noDefaultValue().withDescription("Default comma-separated list of columns that identify a row in tables (primary key)");
    public static final Option<String> TABLE_DEFAULT_PARTITION_KEYS = Options.key((String)"iceberg.table.partition-keys").stringType().noDefaultValue().withDescription("Default comma-separated list of partition fields to use when creating tables.");
    public static final Option<Boolean> TABLE_UPSERT_MODE_ENABLED_PROP = Options.key((String)"iceberg.table.upsert-mode-enabled").booleanType().defaultValue((Object)false).withDescription("Set to `true` to enable upsert mode, default is `false`");
    public static final Option<SchemaSaveMode> SCHEMA_SAVE_MODE = Options.key((String)"schema_save_mode").enumType(SchemaSaveMode.class).defaultValue((Object)SchemaSaveMode.CREATE_SCHEMA_WHEN_NOT_EXIST).withDescription("schema save mode");
    public static final Option<DataSaveMode> DATA_SAVE_MODE = Options.key((String)"data_save_mode").enumType(DataSaveMode.class).defaultValue((Object)DataSaveMode.APPEND_DATA).withDescription("data save mode");
    public static final Option<String> TABLES_DEFAULT_COMMIT_BRANCH = Options.key((String)"iceberg.table.commit-branch").stringType().noDefaultValue().withDescription("Default branch for commits");
    @VisibleForTesting
    private static final String COMMA_NO_PARENS_REGEX = ",(?![^()]*+\\))";
    private final ReadonlyConfig readonlyConfig;
    private Map<String, String> autoCreateProps;
    private Map<String, String> writeProps;
    private List<String> primaryKeys;
    private List<String> partitionKeys;
    private String commitBranch;
    private boolean upsertModeEnabled;
    private boolean tableSchemaEvolutionEnabled;
    private SchemaSaveMode schemaSaveMode;
    private DataSaveMode dataSaveMode;

    public SinkConfig(ReadonlyConfig readonlyConfig) {
        super(readonlyConfig);
        this.readonlyConfig = readonlyConfig;
        this.autoCreateProps = (Map)readonlyConfig.get(AUTO_CREATE_PROPS);
        this.writeProps = (Map)readonlyConfig.get(WRITE_PROPS);
        this.primaryKeys = SinkConfig.stringToList((String)readonlyConfig.get(TABLE_PRIMARY_KEYS), ",");
        this.partitionKeys = SinkConfig.stringToList((String)readonlyConfig.get(TABLE_DEFAULT_PARTITION_KEYS), ",");
        this.upsertModeEnabled = (Boolean)readonlyConfig.get(TABLE_UPSERT_MODE_ENABLED_PROP);
        this.tableSchemaEvolutionEnabled = (Boolean)readonlyConfig.get(TABLE_SCHEMA_EVOLUTION_ENABLED_PROP);
        this.schemaSaveMode = (SchemaSaveMode)readonlyConfig.get(SCHEMA_SAVE_MODE);
        this.dataSaveMode = (DataSaveMode)readonlyConfig.get(DATA_SAVE_MODE);
        this.commitBranch = (String)readonlyConfig.get(TABLES_DEFAULT_COMMIT_BRANCH);
    }

    @VisibleForTesting
    public static List<String> stringToList(String value, String regex) {
        if (value == null || value.isEmpty()) {
            return ImmutableList.of();
        }
        return Arrays.stream(value.split(regex)).map(String::trim).collect(Collectors.toList());
    }

    public ReadonlyConfig getReadonlyConfig() {
        return this.readonlyConfig;
    }

    public Map<String, String> getAutoCreateProps() {
        return this.autoCreateProps;
    }

    public Map<String, String> getWriteProps() {
        return this.writeProps;
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public List<String> getPartitionKeys() {
        return this.partitionKeys;
    }

    public String getCommitBranch() {
        return this.commitBranch;
    }

    public boolean isUpsertModeEnabled() {
        return this.upsertModeEnabled;
    }

    public boolean isTableSchemaEvolutionEnabled() {
        return this.tableSchemaEvolutionEnabled;
    }

    public SchemaSaveMode getSchemaSaveMode() {
        return this.schemaSaveMode;
    }

    public DataSaveMode getDataSaveMode() {
        return this.dataSaveMode;
    }

    public void setAutoCreateProps(Map<String, String> autoCreateProps) {
        this.autoCreateProps = autoCreateProps;
    }

    public void setWriteProps(Map<String, String> writeProps) {
        this.writeProps = writeProps;
    }

    public void setPrimaryKeys(List<String> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public void setPartitionKeys(List<String> partitionKeys) {
        this.partitionKeys = partitionKeys;
    }

    public void setCommitBranch(String commitBranch) {
        this.commitBranch = commitBranch;
    }

    public void setUpsertModeEnabled(boolean upsertModeEnabled) {
        this.upsertModeEnabled = upsertModeEnabled;
    }

    public void setTableSchemaEvolutionEnabled(boolean tableSchemaEvolutionEnabled) {
        this.tableSchemaEvolutionEnabled = tableSchemaEvolutionEnabled;
    }

    public void setSchemaSaveMode(SchemaSaveMode schemaSaveMode) {
        this.schemaSaveMode = schemaSaveMode;
    }

    public void setDataSaveMode(DataSaveMode dataSaveMode) {
        this.dataSaveMode = dataSaveMode;
    }

    @Override
    public String toString() {
        return "SinkConfig(readonlyConfig=" + this.getReadonlyConfig() + ", autoCreateProps=" + this.getAutoCreateProps() + ", writeProps=" + this.getWriteProps() + ", primaryKeys=" + this.getPrimaryKeys() + ", partitionKeys=" + this.getPartitionKeys() + ", commitBranch=" + this.getCommitBranch() + ", upsertModeEnabled=" + this.isUpsertModeEnabled() + ", tableSchemaEvolutionEnabled=" + this.isTableSchemaEvolutionEnabled() + ", schemaSaveMode=" + this.getSchemaSaveMode() + ", dataSaveMode=" + this.getDataSaveMode() + ")";
    }
}

