/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.config;

import org.apache.iceberg.expressions.Expression;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.CommonConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.scan.IcebergStreamScanStrategy;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class SourceConfig
extends CommonConfig {
    private static final long serialVersionUID = -1965861967575264253L;
    public static final Option<Long> KEY_START_SNAPSHOT_TIMESTAMP = Options.key((String)"start_snapshot_timestamp").longType().noDefaultValue().withDescription(" the iceberg timestamp of starting snapshot ");
    public static final Option<Long> KEY_START_SNAPSHOT_ID = Options.key((String)"start_snapshot_id").longType().noDefaultValue().withDescription(" the iceberg id of starting snapshot ");
    public static final Option<Long> KEY_END_SNAPSHOT_ID = Options.key((String)"end_snapshot_id").longType().noDefaultValue().withDescription(" the iceberg id of ending snapshot ");
    public static final Option<Long> KEY_USE_SNAPSHOT_ID = Options.key((String)"use_snapshot_id").longType().noDefaultValue().withDescription(" the iceberg used snapshot id");
    public static final Option<Long> KEY_USE_SNAPSHOT_TIMESTAMP = Options.key((String)"use_snapshot_timestamp").longType().noDefaultValue().withDescription(" the iceberg used snapshot timestamp");
    public static final Option<IcebergStreamScanStrategy> KEY_STREAM_SCAN_STRATEGY = Options.key((String)"stream_scan_strategy").enumType(IcebergStreamScanStrategy.class).defaultValue((Object)IcebergStreamScanStrategy.FROM_LATEST_SNAPSHOT).withDescription(" the iceberg strategy of stream scanning");
    private Long startSnapshotTimestamp;
    private Long startSnapshotId;
    private Long endSnapshotId;
    private Long useSnapshotId;
    private Long useSnapshotTimestamp;
    private IcebergStreamScanStrategy streamScanStrategy = (IcebergStreamScanStrategy)((Object)KEY_STREAM_SCAN_STRATEGY.defaultValue());
    private Expression filter;
    private Long splitSize;
    private Integer splitLookback;
    private Long splitOpenFileCost;

    public SourceConfig(ReadonlyConfig readonlyConfig) {
        super(readonlyConfig);
        Config pluginConfig = readonlyConfig.toConfig();
        if (pluginConfig.hasPath(KEY_START_SNAPSHOT_TIMESTAMP.key())) {
            this.startSnapshotTimestamp = pluginConfig.getLong(KEY_START_SNAPSHOT_TIMESTAMP.key());
        }
        if (pluginConfig.hasPath(KEY_START_SNAPSHOT_ID.key())) {
            this.startSnapshotId = pluginConfig.getLong(KEY_START_SNAPSHOT_ID.key());
        }
        if (pluginConfig.hasPath(KEY_END_SNAPSHOT_ID.key())) {
            this.endSnapshotId = pluginConfig.getLong(KEY_END_SNAPSHOT_ID.key());
        }
        if (pluginConfig.hasPath(KEY_USE_SNAPSHOT_ID.key())) {
            this.useSnapshotId = pluginConfig.getLong(KEY_USE_SNAPSHOT_ID.key());
        }
        if (pluginConfig.hasPath(KEY_USE_SNAPSHOT_TIMESTAMP.key())) {
            this.useSnapshotTimestamp = pluginConfig.getLong(KEY_USE_SNAPSHOT_TIMESTAMP.key());
        }
        if (pluginConfig.hasPath(KEY_STREAM_SCAN_STRATEGY.key())) {
            this.streamScanStrategy = (IcebergStreamScanStrategy)pluginConfig.getEnum(IcebergStreamScanStrategy.class, KEY_STREAM_SCAN_STRATEGY.key());
        }
    }

    public static SourceConfig loadConfig(ReadonlyConfig pluginConfig) {
        return new SourceConfig(pluginConfig);
    }

    public Long getStartSnapshotTimestamp() {
        return this.startSnapshotTimestamp;
    }

    public Long getStartSnapshotId() {
        return this.startSnapshotId;
    }

    public Long getEndSnapshotId() {
        return this.endSnapshotId;
    }

    public Long getUseSnapshotId() {
        return this.useSnapshotId;
    }

    public Long getUseSnapshotTimestamp() {
        return this.useSnapshotTimestamp;
    }

    public IcebergStreamScanStrategy getStreamScanStrategy() {
        return this.streamScanStrategy;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public Long getSplitSize() {
        return this.splitSize;
    }

    public Integer getSplitLookback() {
        return this.splitLookback;
    }

    public Long getSplitOpenFileCost() {
        return this.splitOpenFileCost;
    }

    @Override
    public String toString() {
        return "SourceConfig(startSnapshotTimestamp=" + this.getStartSnapshotTimestamp() + ", startSnapshotId=" + this.getStartSnapshotId() + ", endSnapshotId=" + this.getEndSnapshotId() + ", useSnapshotId=" + this.getUseSnapshotId() + ", useSnapshotTimestamp=" + this.getUseSnapshotTimestamp() + ", streamScanStrategy=" + (Object)((Object)this.getStreamScanStrategy()) + ", filter=" + this.getFilter() + ", splitSize=" + this.getSplitSize() + ", splitLookback=" + this.getSplitLookback() + ", splitOpenFileCost=" + this.getSplitOpenFileCost() + ")";
    }
}

