/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.data;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.types.Types;

public class IcebergRecordProjection
implements Record {
    private final Record record;
    private final Types.StructType structType;
    private final Types.StructType projectStructType;
    private final Map<Integer, Integer> posMapping;

    public IcebergRecordProjection(@NonNull Record record, @NonNull Types.StructType structType, @NonNull Types.StructType projectStructType) {
        if (record == null) {
            throw new NullPointerException("record is marked non-null but is null");
        }
        if (structType == null) {
            throw new NullPointerException("structType is marked non-null but is null");
        }
        if (projectStructType == null) {
            throw new NullPointerException("projectStructType is marked non-null but is null");
        }
        HashMap<Integer, Integer> posMapping = new HashMap<Integer, Integer>();
        int len = projectStructType.fields().size();
        for (int projectPos = 0; projectPos < len; ++projectPos) {
            Types.NestedField projectField = projectStructType.fields().get(projectPos);
            Types.NestedField field = structType.field(projectField.fieldId());
            int fieldPos = structType.fields().indexOf(field);
            posMapping.put(projectPos, fieldPos);
        }
        this.record = record;
        this.structType = structType;
        this.projectStructType = projectStructType;
        this.posMapping = posMapping;
    }

    @Override
    public Types.StructType struct() {
        return this.projectStructType;
    }

    @Override
    public Object getField(String name) {
        return this.record.getField(name);
    }

    @Override
    public void setField(String name, Object value) {
        this.record.setField(name, value);
    }

    @Override
    public Object get(int pos) {
        return this.record.get(this.posMapping.get(pos));
    }

    @Override
    public Record copy() {
        return new IcebergRecordProjection(this.record.copy(), this.structType, this.projectStructType);
    }

    @Override
    public Record copy(Map<String, Object> overwriteValues) {
        return new IcebergRecordProjection(this.record.copy(overwriteValues), this.structType, this.projectStructType);
    }

    @Override
    public int size() {
        return this.projectStructType.fields().size();
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        return this.record.get(this.posMapping.get(pos), javaClass);
    }

    @Override
    public <T> void set(int pos, T value) {
        this.record.set(this.posMapping.get(pos), value);
    }
}

