/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.data;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;

public class IcebergTypeMapper {
    public static SeaTunnelDataType<?> mapping(String field, @NonNull Type icebergType) {
        if (icebergType == null) {
            throw new NullPointerException("icebergType is marked non-null but is null");
        }
        switch (icebergType.typeId()) {
            case BOOLEAN: {
                return BasicType.BOOLEAN_TYPE;
            }
            case INTEGER: {
                return BasicType.INT_TYPE;
            }
            case LONG: {
                return BasicType.LONG_TYPE;
            }
            case FLOAT: {
                return BasicType.FLOAT_TYPE;
            }
            case DOUBLE: {
                return BasicType.DOUBLE_TYPE;
            }
            case DATE: {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case TIME: {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case TIMESTAMP: {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case STRING: {
                return BasicType.STRING_TYPE;
            }
            case FIXED: 
            case BINARY: {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)icebergType;
                return new DecimalType(decimalType.precision(), decimalType.scale());
            }
            case STRUCT: {
                return IcebergTypeMapper.mappingStructType((Types.StructType)icebergType);
            }
            case LIST: {
                return IcebergTypeMapper.mappingListType(field, (Types.ListType)icebergType);
            }
            case MAP: {
                return IcebergTypeMapper.mappingMapType(field, (Types.MapType)icebergType);
            }
        }
        throw CommonError.convertToSeaTunnelTypeError((String)"Iceberg", (String)icebergType.toString(), (String)field);
    }

    private static SeaTunnelRowType mappingStructType(Types.StructType structType) {
        List<Types.NestedField> fields = structType.fields();
        ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
        ArrayList fieldTypes = new ArrayList(fields.size());
        for (Types.NestedField field : fields) {
            fieldNames.add(field.name());
            fieldTypes.add(IcebergTypeMapper.mapping(field.name(), field.type()));
        }
        return new SeaTunnelRowType(fieldNames.toArray(new String[0]), fieldTypes.toArray(new SeaTunnelDataType[0]));
    }

    private static ArrayType mappingListType(String field, Types.ListType listType) {
        switch (listType.elementType().typeId()) {
            case BOOLEAN: {
                return ArrayType.BOOLEAN_ARRAY_TYPE;
            }
            case INTEGER: {
                return ArrayType.INT_ARRAY_TYPE;
            }
            case LONG: {
                return ArrayType.LONG_ARRAY_TYPE;
            }
            case FLOAT: {
                return ArrayType.FLOAT_ARRAY_TYPE;
            }
            case DOUBLE: {
                return ArrayType.DOUBLE_ARRAY_TYPE;
            }
            case STRING: {
                return ArrayType.STRING_ARRAY_TYPE;
            }
        }
        throw CommonError.convertToSeaTunnelTypeError((String)"Iceberg", (String)listType.toString(), (String)field);
    }

    private static MapType mappingMapType(String field, Types.MapType mapType) {
        return new MapType(IcebergTypeMapper.mapping(field, mapType.keyType()), IcebergTypeMapper.mapping(field, mapType.valueType()));
    }

    public static Type toIcebergType(SeaTunnelDataType dataType) {
        return IcebergTypeMapper.toIcebergType(dataType, new AtomicInteger(1));
    }

    private static Type toIcebergType(SeaTunnelDataType dataType, AtomicInteger nextId) {
        switch (dataType.getSqlType()) {
            case BOOLEAN: {
                return Types.BooleanType.get();
            }
            case BYTES: {
                return Types.BinaryType.get();
            }
            case SMALLINT: 
            case TINYINT: 
            case INT: {
                return Types.IntegerType.get();
            }
            case BIGINT: {
                return Types.LongType.get();
            }
            case FLOAT: {
                return Types.FloatType.get();
            }
            case DOUBLE: {
                return Types.DoubleType.get();
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)dataType;
                return Types.DecimalType.of(decimalType.getPrecision(), decimalType.getScale());
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)dataType;
                Type elementType = IcebergTypeMapper.toIcebergType(arrayType.getElementType(), nextId);
                return Types.ListType.ofOptional(nextId.getAndIncrement(), elementType);
            }
            case MAP: {
                MapType mapType = (MapType)dataType;
                Type keyType = IcebergTypeMapper.toIcebergType(mapType.getKeyType(), nextId);
                Type valueType = IcebergTypeMapper.toIcebergType(mapType.getValueType(), nextId);
                return Types.MapType.ofOptional(nextId.getAndIncrement(), nextId.getAndIncrement(), keyType, valueType);
            }
            case ROW: {
                SeaTunnelRowType seaTunnelRowType = (SeaTunnelRowType)dataType;
                ArrayList<Types.NestedField> structFields = new ArrayList<Types.NestedField>();
                for (int i = 0; i < seaTunnelRowType.getFieldNames().length; ++i) {
                    String field = seaTunnelRowType.getFieldName(i);
                    SeaTunnelDataType fieldType = seaTunnelRowType.getFieldType(i);
                    structFields.add(Types.NestedField.of(nextId.getAndIncrement(), true, field, IcebergTypeMapper.toIcebergType(fieldType, nextId)));
                }
                return Types.StructType.of(structFields);
            }
            case DATE: {
                return Types.DateType.get();
            }
            case TIME: {
                return Types.TimeType.get();
            }
            case TIMESTAMP: {
                return Types.TimestampType.withZone();
            }
        }
        return Types.StringType.get();
    }
}

