/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Types;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.connectors.seatunnel.iceberg.IcebergTableLoader;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.SourceConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.IcebergBatchSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.IcebergSplitEnumeratorState;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.IcebergStreamSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.scan.IcebergScanContext;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.reader.IcebergSourceReader;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.split.IcebergFileScanTaskSplit;
import org.apache.seatunnel.connectors.seatunnel.iceberg.utils.SchemaUtils;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class IcebergSource
implements SeaTunnelSource<SeaTunnelRow, IcebergFileScanTaskSplit, IcebergSplitEnumeratorState>,
SupportParallelism,
SupportColumnProjection {
    private static final long serialVersionUID = 4343414808223919870L;
    private SourceConfig sourceConfig;
    private Schema tableSchema;
    private Schema projectedSchema;
    private SeaTunnelRowType seaTunnelRowType;
    private JobContext jobContext;
    private CatalogTable catalogTable;

    public IcebergSource(ReadonlyConfig config, CatalogTable catalogTable) {
        this.sourceConfig = SourceConfig.loadConfig(config);
        this.tableSchema = this.loadIcebergSchema(this.sourceConfig);
        this.seaTunnelRowType = this.loadSeaTunnelRowType(this.tableSchema, config.toConfig());
        this.projectedSchema = this.tableSchema.select(this.seaTunnelRowType.getFieldNames());
        this.catalogTable = catalogTable;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return Collections.singletonList(this.catalogTable);
    }

    public String getPluginName() {
        return "Iceberg";
    }

    private Schema loadIcebergSchema(SourceConfig sourceConfig) {
        Schema schema;
        block8: {
            IcebergTableLoader icebergTableLoader = IcebergTableLoader.create(sourceConfig, this.catalogTable);
            try {
                icebergTableLoader.open();
                schema = icebergTableLoader.loadTable().schema();
                if (icebergTableLoader == null) break block8;
            }
            catch (Throwable throwable) {
                if (icebergTableLoader != null) {
                    try {
                        icebergTableLoader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            icebergTableLoader.close();
        }
        return schema;
    }

    private SeaTunnelRowType loadSeaTunnelRowType(Schema tableSchema, Config pluginConfig) {
        ArrayList<String> columnNames = new ArrayList<String>(tableSchema.columns().size());
        ArrayList columnDataTypes = new ArrayList(tableSchema.columns().size());
        for (Types.NestedField column : tableSchema.columns()) {
            columnNames.add(column.name());
            columnDataTypes.add(SchemaUtils.toSeaTunnelType(column.name(), column.type()));
        }
        SeaTunnelRowType originalRowType = new SeaTunnelRowType(columnNames.toArray(new String[0]), columnDataTypes.toArray(new SeaTunnelDataType[0]));
        CheckResult checkResult = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{TableSchemaOptions.SCHEMA.key()});
        if (checkResult.isSuccess()) {
            SeaTunnelRowType projectedRowType = CatalogTableUtil.buildWithConfig((Config)pluginConfig).getSeaTunnelRowType();
            for (int i = 0; i < projectedRowType.getFieldNames().length; ++i) {
                String fieldName = projectedRowType.getFieldName(i);
                SeaTunnelDataType projectedFieldType = projectedRowType.getFieldType(i);
                int originalFieldIndex = originalRowType.indexOf(fieldName);
                SeaTunnelDataType originalFieldType = originalRowType.getFieldType(originalFieldIndex);
                Preconditions.checkArgument((boolean)projectedFieldType.equals(originalFieldType), (Object)String.format("Illegal field: %s, original: %s <-> projected: %s", fieldName, originalFieldType, projectedFieldType));
            }
            return projectedRowType;
        }
        return originalRowType;
    }

    public Boundedness getBoundedness() {
        return JobMode.BATCH.equals((Object)this.jobContext.getJobMode()) ? Boundedness.BOUNDED : Boundedness.UNBOUNDED;
    }

    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    public SourceReader<SeaTunnelRow, IcebergFileScanTaskSplit> createReader(SourceReader.Context readerContext) {
        return new IcebergSourceReader(readerContext, this.seaTunnelRowType, this.tableSchema, this.projectedSchema, this.sourceConfig, this.catalogTable);
    }

    public SourceSplitEnumerator<IcebergFileScanTaskSplit, IcebergSplitEnumeratorState> createEnumerator(SourceSplitEnumerator.Context<IcebergFileScanTaskSplit> enumeratorContext) {
        if (Boundedness.BOUNDED.equals((Object)this.getBoundedness())) {
            return new IcebergBatchSplitEnumerator(enumeratorContext, IcebergScanContext.scanContext(this.sourceConfig, this.projectedSchema), this.sourceConfig, null, this.catalogTable);
        }
        return new IcebergStreamSplitEnumerator(enumeratorContext, IcebergScanContext.streamScanContext(this.sourceConfig, this.projectedSchema), this.sourceConfig, null, this.catalogTable);
    }

    public SourceSplitEnumerator<IcebergFileScanTaskSplit, IcebergSplitEnumeratorState> restoreEnumerator(SourceSplitEnumerator.Context<IcebergFileScanTaskSplit> enumeratorContext, IcebergSplitEnumeratorState checkpointState) {
        if (Boundedness.BOUNDED.equals((Object)this.getBoundedness())) {
            return new IcebergBatchSplitEnumerator(enumeratorContext, IcebergScanContext.scanContext(this.sourceConfig, this.projectedSchema), this.sourceConfig, checkpointState, this.catalogTable);
        }
        return new IcebergStreamSplitEnumerator(enumeratorContext, IcebergScanContext.streamScanContext(this.sourceConfig, this.projectedSchema), this.sourceConfig, checkpointState, this.catalogTable);
    }
}

