/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.iceberg.catalog.IcebergCatalog;
import org.apache.seatunnel.connectors.seatunnel.iceberg.catalog.IcebergCatalogFactory;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.CommonConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.SinkConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.SourceConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.IcebergSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Factory.class})
public class IcebergSourceFactory
implements TableSourceFactory {
    private static final Logger log = LoggerFactory.getLogger(IcebergSourceFactory.class);

    public String factoryIdentifier() {
        return "Iceberg";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{CommonConfig.KEY_CATALOG_NAME, SinkConfig.KEY_NAMESPACE, SinkConfig.KEY_TABLE, SinkConfig.CATALOG_PROPS}).optional(new Option[]{TableSchemaOptions.SCHEMA, CommonConfig.KEY_CASE_SENSITIVE, SourceConfig.KEY_START_SNAPSHOT_TIMESTAMP, SourceConfig.KEY_START_SNAPSHOT_ID, SourceConfig.KEY_END_SNAPSHOT_ID, SourceConfig.KEY_USE_SNAPSHOT_ID, SourceConfig.KEY_USE_SNAPSHOT_TIMESTAMP, SourceConfig.KEY_STREAM_SCAN_STRATEGY}).build();
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        ReadonlyConfig options = context.getOptions();
        SourceConfig config = new SourceConfig(options);
        TablePath tablePath = TablePath.of((String)config.getNamespace(), (String)config.getTable());
        if (options.get(TableSchemaOptions.SCHEMA) != null) {
            CatalogTable catalogTable = CatalogTableUtil.buildWithConfig((String)this.factoryIdentifier(), (ReadonlyConfig)options);
            TableIdentifier tableIdentifier = TableIdentifier.of((String)catalogTable.getCatalogName(), (TablePath)tablePath);
            CatalogTable table = CatalogTable.of((TableIdentifier)tableIdentifier, (CatalogTable)catalogTable);
            return () -> new IcebergSource(options, table);
        }
        IcebergCatalogFactory icebergCatalogFactory = new IcebergCatalogFactory();
        IcebergCatalog catalog = (IcebergCatalog)icebergCatalogFactory.createCatalog(this.factoryIdentifier(), options);
        catalog.open();
        CatalogTable catalogTable = catalog.getTable(tablePath);
        return () -> new IcebergSource(options, catalogTable);
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return IcebergSource.class;
    }
}

