/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final ThreadLocal<byte[]> SKIP_BYTE_BUFFER = ThreadLocal.withInitial(IOUtils::byteArray);

    public static byte[] byteArray() {
        return IOUtils.byteArray(8192);
    }

    public static byte[] byteArray(int size) {
        return new byte[size];
    }

    static byte[] getByteArray() {
        return SKIP_BYTE_BUFFER.get();
    }

    public static void skipFully(InputStream input, long toSkip) throws IOException {
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + toSkip);
        }
        long skipped = IOUtils.skip(input, toSkip);
        if (skipped != toSkip) {
            throw new EOFException("Bytes to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static long skip(InputStream input, long toSkip) throws IOException {
        byte[] byteArray;
        long remain;
        long n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        for (remain = toSkip; remain > 0L && (n = (long)input.read(byteArray = IOUtils.getByteArray(), 0, (int)Math.min(remain, (long)byteArray.length))) >= 0L; remain -= n) {
        }
        return toSkip - remain;
    }
}

