/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroCustomOrderSchemaVisitor;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.BuildAvroProjection;
import org.apache.iceberg.avro.HasIds;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.avro.MissingIds;
import org.apache.iceberg.avro.PruneColumns;
import org.apache.iceberg.avro.SchemaToType;
import org.apache.iceberg.avro.TypeToSchema;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.JsonProperties;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.LogicalType;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.LogicalTypes;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema;

public class AvroSchemaUtil {
    public static final String ICEBERG_FIELD_NAME_PROP = "iceberg-field-name";
    public static final String FIELD_ID_PROP = "field-id";
    public static final String KEY_ID_PROP = "key-id";
    public static final String VALUE_ID_PROP = "value-id";
    public static final String ELEMENT_ID_PROP = "element-id";
    public static final String ADJUST_TO_UTC_PROP = "adjust-to-utc";
    private static final org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema NULL = org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema.create(Schema.Type.NULL);
    private static final Schema.Type MAP = Schema.Type.MAP;
    private static final Schema.Type ARRAY = Schema.Type.ARRAY;
    private static final Schema.Type UNION = Schema.Type.UNION;
    private static final Schema.Type RECORD = Schema.Type.RECORD;

    private AvroSchemaUtil() {
    }

    public static org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema convert(Schema schema, String tableName) {
        return AvroSchemaUtil.convert(schema, ImmutableMap.of(schema.asStruct(), tableName));
    }

    public static org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema convert(Schema schema, Map<Types.StructType, String> names) {
        return TypeUtil.visit(schema, new TypeToSchema(names));
    }

    public static org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema convert(Type type) {
        return AvroSchemaUtil.convert(type, ImmutableMap.of());
    }

    public static org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema convert(Types.StructType type, String name) {
        return AvroSchemaUtil.convert((Type)type, ImmutableMap.of(type, name));
    }

    public static org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema convert(Type type, Map<Types.StructType, String> names) {
        return TypeUtil.visit(type, new TypeToSchema(names));
    }

    public static Type convert(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema) {
        return AvroSchemaVisitor.visit(schema, new SchemaToType(schema));
    }

    public static Schema toIceberg(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema) {
        List<Types.NestedField> fields = AvroSchemaUtil.convert(schema).asNestedType().asStructType().fields();
        return new Schema(fields);
    }

    static boolean hasIds(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema) {
        return AvroCustomOrderSchemaVisitor.visit(schema, new HasIds());
    }

    static boolean missingIds(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema) {
        return AvroCustomOrderSchemaVisitor.visit(schema, new MissingIds());
    }

    public static Map<Type, org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema> convertTypes(Types.StructType type, String name) {
        TypeToSchema converter = new TypeToSchema(ImmutableMap.of(type, name));
        TypeUtil.visit((Type)type, converter);
        return ImmutableMap.copyOf(converter.getConversionMap());
    }

    public static org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema pruneColumns(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema, Set<Integer> selectedIds, NameMapping nameMapping) {
        return new PruneColumns(selectedIds, nameMapping).rootSchema(schema);
    }

    public static org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema buildAvroProjection(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema, Schema expected, Map<String, String> renames) {
        return AvroCustomOrderSchemaVisitor.visit(schema, new BuildAvroProjection(expected, renames));
    }

    public static boolean isTimestamptz(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType instanceof LogicalTypes.TimestampMillis || logicalType instanceof LogicalTypes.TimestampMicros) {
            Object value = schema.getObjectProp(ADJUST_TO_UTC_PROP);
            if (value == null) {
                return false;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
        }
        return false;
    }

    public static boolean isOptionSchema(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema) {
        if (schema.getType() == UNION && schema.getTypes().size() == 2) {
            if (schema.getTypes().get(0).getType() == Schema.Type.NULL) {
                return true;
            }
            if (schema.getTypes().get(1).getType() == Schema.Type.NULL) {
                return true;
            }
        }
        return false;
    }

    static org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema toOption(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema) {
        if (schema.getType() == UNION) {
            Preconditions.checkArgument(AvroSchemaUtil.isOptionSchema(schema), "Union schemas are not supported: %s", (Object)schema);
            return schema;
        }
        return org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema.createUnion(NULL, schema);
    }

    static org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema fromOption(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema) {
        Preconditions.checkArgument(schema.getType() == UNION, "Expected union schema but was passed: %s", (Object)schema);
        Preconditions.checkArgument(schema.getTypes().size() == 2, "Expected optional schema, but was passed: %s", (Object)schema);
        if (schema.getTypes().get(0).getType() == Schema.Type.NULL) {
            return schema.getTypes().get(1);
        }
        return schema.getTypes().get(0);
    }

    static org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema fromOptions(List<org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema> options) {
        Preconditions.checkArgument(options.size() == 2, "Expected two schemas, but was passed: %s options", options.size());
        if (options.get(0).getType() == Schema.Type.NULL) {
            return options.get(1);
        }
        return options.get(0);
    }

    public static boolean isKeyValueSchema(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema) {
        return schema.getType() == RECORD && schema.getFields().size() == 2;
    }

    static org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema createMap(int keyId, org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema keySchema, int valueId, org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema valueSchema) {
        String keyValueName = "k" + keyId + "_v" + valueId;
        Schema.Field keyField = new Schema.Field("key", keySchema, null, null);
        keyField.addProp(FIELD_ID_PROP, keyId);
        Schema.Field valueField = new Schema.Field("value", valueSchema, null, AvroSchemaUtil.isOptionSchema(valueSchema) ? JsonProperties.NULL_VALUE : null);
        valueField.addProp(FIELD_ID_PROP, valueId);
        return LogicalMap.get().addToSchema(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema.createArray(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema.createRecord(keyValueName, null, null, false, ImmutableList.of(keyField, valueField))));
    }

    static org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema createProjectionMap(String recordName, int keyId, String keyName, org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema keySchema, int valueId, String valueName, org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema valueSchema) {
        String keyValueName = "k" + keyId + "_v" + valueId;
        Schema.Field keyField = new Schema.Field("key", keySchema, null, null);
        if (!"key".equals(keyName)) {
            keyField.addAlias(keyName);
        }
        keyField.addProp(FIELD_ID_PROP, keyId);
        Schema.Field valueField = new Schema.Field("value", valueSchema, null, AvroSchemaUtil.isOptionSchema(valueSchema) ? JsonProperties.NULL_VALUE : null);
        valueField.addProp(FIELD_ID_PROP, valueId);
        if (!"value".equals(valueName)) {
            valueField.addAlias(valueName);
        }
        org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema keyValueRecord = org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema.createRecord(keyValueName, null, null, false, ImmutableList.of(keyField, valueField));
        if (!keyValueName.equals(recordName)) {
            keyValueRecord.addAlias(recordName);
        }
        return LogicalMap.get().addToSchema(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema.createArray(keyValueRecord));
    }

    private static Integer getId(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema, String propertyName) {
        Integer id = AvroSchemaUtil.getId(schema, propertyName, null, null);
        Preconditions.checkNotNull(id, "Missing expected '%s' property", (Object)propertyName);
        return id;
    }

    private static Integer getId(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema, String propertyName, NameMapping nameMapping, List<String> names) {
        MappedField mappedField;
        if (schema.getType() == UNION) {
            return AvroSchemaUtil.getId(AvroSchemaUtil.fromOption(schema), propertyName, nameMapping, names);
        }
        Object id = schema.getObjectProp(propertyName);
        if (id != null) {
            return AvroSchemaUtil.toInt(id);
        }
        if (nameMapping != null && (mappedField = nameMapping.find(names)) != null) {
            return mappedField.id();
        }
        return null;
    }

    static boolean hasProperty(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema, String propertyName) {
        if (schema.getType() == UNION) {
            return AvroSchemaUtil.hasProperty(AvroSchemaUtil.fromOption(schema), propertyName);
        }
        return schema.getObjectProp(propertyName) != null;
    }

    public static int getKeyId(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema) {
        Preconditions.checkArgument(schema.getType() == MAP, "Cannot get map key id for non-map schema: %s", (Object)schema);
        return AvroSchemaUtil.getId(schema, KEY_ID_PROP);
    }

    static Integer getKeyId(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema, NameMapping nameMapping, Iterable<String> parentFieldNames) {
        Preconditions.checkArgument(schema.getType() == MAP, "Cannot get map key id for non-map schema: %s", (Object)schema);
        ArrayList<String> names = Lists.newArrayList(parentFieldNames);
        names.add("key");
        return AvroSchemaUtil.getId(schema, KEY_ID_PROP, nameMapping, names);
    }

    public static int getValueId(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema) {
        Preconditions.checkArgument(schema.getType() == MAP, "Cannot get map value id for non-map schema: %s", (Object)schema);
        return AvroSchemaUtil.getId(schema, VALUE_ID_PROP);
    }

    static Integer getValueId(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema, NameMapping nameMapping, Iterable<String> parentFieldNames) {
        Preconditions.checkArgument(schema.getType() == MAP, "Cannot get map value id for non-map schema: %s", (Object)schema);
        ArrayList<String> names = Lists.newArrayList(parentFieldNames);
        names.add("value");
        return AvroSchemaUtil.getId(schema, VALUE_ID_PROP, nameMapping, names);
    }

    public static int getElementId(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema) {
        Preconditions.checkArgument(schema.getType() == ARRAY, "Cannot get array element id for non-array schema: %s", (Object)schema);
        return AvroSchemaUtil.getId(schema, ELEMENT_ID_PROP);
    }

    static Integer getElementId(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema schema, NameMapping nameMapping, Iterable<String> parentFieldNames) {
        Preconditions.checkArgument(schema.getType() == ARRAY, "Cannot get array element id for non-array schema: %s", (Object)schema);
        ArrayList<String> names = Lists.newArrayList(parentFieldNames);
        names.add("element");
        return AvroSchemaUtil.getId(schema, ELEMENT_ID_PROP, nameMapping, names);
    }

    public static int getFieldId(Schema.Field field) {
        Integer id = AvroSchemaUtil.getFieldId(field, null, null);
        Preconditions.checkNotNull(id, "Missing expected '%s' property", (Object)FIELD_ID_PROP);
        return id;
    }

    static Integer getFieldId(Schema.Field field, NameMapping nameMapping, Iterable<String> parentFieldNames) {
        Object id = field.getObjectProp(FIELD_ID_PROP);
        if (id != null) {
            return AvroSchemaUtil.toInt(id);
        }
        if (nameMapping != null) {
            ArrayList<String> names = Lists.newArrayList(parentFieldNames);
            names.add(field.name());
            MappedField mappedField = nameMapping.find(names);
            if (mappedField != null) {
                return mappedField.id();
            }
        }
        return null;
    }

    public static boolean hasFieldId(Schema.Field field) {
        return field.getObjectProp(FIELD_ID_PROP) != null;
    }

    private static int toInt(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new UnsupportedOperationException("Cannot coerce value to int: " + value);
    }

    static org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema copyRecord(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema record, List<Schema.Field> newFields, String newName) {
        org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema copy;
        if (newName != null) {
            copy = org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema.createRecord(newName, record.getDoc(), null, record.isError(), newFields);
            copy.addAlias(record.getName(), record.getNamespace() == null ? "" : record.getNamespace());
        } else {
            copy = org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema.createRecord(record.getName(), record.getDoc(), record.getNamespace(), record.isError(), newFields);
        }
        for (Map.Entry<String, Object> prop : record.getObjectProps().entrySet()) {
            copy.addProp(prop.getKey(), prop.getValue());
        }
        return copy;
    }

    static Schema.Field copyField(Schema.Field field, org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema newSchema, String newName) {
        Schema.Field copy = new Schema.Field(newName, newSchema, field.doc(), field.defaultVal(), field.order());
        for (Map.Entry<String, Object> prop : field.getObjectProps().entrySet()) {
            copy.addProp(prop.getKey(), prop.getValue());
        }
        if (!newName.equals(field.name())) {
            copy.addAlias(field.name());
        }
        return copy;
    }

    static org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema replaceElement(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema array, org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema elementSchema) {
        Preconditions.checkArgument(array.getType() == ARRAY, "Cannot invoke replaceElement on non array schema: %s", (Object)array);
        org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema copy = org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema.createArray(elementSchema);
        for (Map.Entry<String, Object> prop : array.getObjectProps().entrySet()) {
            copy.addProp(prop.getKey(), prop.getValue());
        }
        return copy;
    }

    static org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema replaceValue(org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema map, org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema valueSchema) {
        Preconditions.checkArgument(map.getType() == MAP, "Cannot invoke replaceValue on non map schema: %s", (Object)map);
        org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema copy = org.apache.seatunnel.shade.connector-iceberg.org.apache.avro.Schema.createMap(valueSchema);
        for (Map.Entry<String, Object> prop : map.getObjectProps().entrySet()) {
            copy.addProp(prop.getKey(), prop.getValue());
        }
        return copy;
    }

    public static String makeCompatibleName(String name) {
        if (!AvroSchemaUtil.validAvroName(name)) {
            return AvroSchemaUtil.sanitize(name);
        }
        return name;
    }

    static boolean validAvroName(String name) {
        int length = name.length();
        Preconditions.checkArgument(length > 0, "Empty name");
        char first = name.charAt(0);
        if (!Character.isLetter(first) && first != '_') {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            char character = name.charAt(i);
            if (Character.isLetterOrDigit(character) || character == '_') continue;
            return false;
        }
        return true;
    }

    static String sanitize(String name) {
        int length = name.length();
        StringBuilder sb = new StringBuilder(name.length());
        char first = name.charAt(0);
        if (!Character.isLetter(first) && first != '_') {
            sb.append(AvroSchemaUtil.sanitize(first));
        } else {
            sb.append(first);
        }
        for (int i = 1; i < length; ++i) {
            char character = name.charAt(i);
            if (!Character.isLetterOrDigit(character) && character != '_') {
                sb.append(AvroSchemaUtil.sanitize(character));
                continue;
            }
            sb.append(character);
        }
        return sb.toString();
    }

    private static String sanitize(char character) {
        if (Character.isDigit(character)) {
            return "_" + character;
        }
        return "_x" + Integer.toHexString(character).toUpperCase();
    }
}

