/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class MetastoreUtil {
    private static final DynMethods.UnboundMethod ALTER_TABLE = DynMethods.builder("alter_table").impl(IMetaStoreClient.class, "alter_table_with_environmentContext", String.class, String.class, Table.class, EnvironmentContext.class).impl(IMetaStoreClient.class, "alter_table", String.class, String.class, Table.class, EnvironmentContext.class).impl(IMetaStoreClient.class, "alter_table", String.class, String.class, Table.class).build();

    private MetastoreUtil() {
    }

    public static void alterTable(IMetaStoreClient client, String databaseName, String tblName, Table table) {
        MetastoreUtil.alterTable(client, databaseName, tblName, table, ImmutableMap.of());
    }

    public static void alterTable(IMetaStoreClient client, String databaseName, String tblName, Table table, Map<String, String> extraEnv) {
        HashMap<String, String> env = Maps.newHashMapWithExpectedSize(extraEnv.size() + 1);
        env.putAll(extraEnv);
        env.put("DO_NOT_UPDATE_STATS", "true");
        ALTER_TABLE.invoke(client, databaseName, tblName, table, new EnvironmentContext(env));
    }
}

