/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.parquet.ColumnIterator;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.TripleIterator;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.ColumnDescriptor;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.column.page.PageReadStore;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.io.api.Binary;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.schema.Type;

public class ParquetValueReaders {
    private ParquetValueReaders() {
    }

    public static <T> ParquetValueReader<T> option(Type type, int definitionLevel, ParquetValueReader<T> reader) {
        if (type.isRepetition(Type.Repetition.OPTIONAL)) {
            return new OptionReader<T>(definitionLevel, reader);
        }
        return reader;
    }

    public static <T> ParquetValueReader<T> nulls() {
        return NullReader.INSTANCE;
    }

    public static <C> ParquetValueReader<C> constant(C value) {
        return new ConstantReader<C>(value);
    }

    public static <C> ParquetValueReader<C> constant(C value, int definitionLevel) {
        return new ConstantReader<C>(value, definitionLevel);
    }

    public static ParquetValueReader<Long> position() {
        return new PositionReader();
    }

    public static abstract class StructReader<T, I>
    implements ParquetValueReader<T> {
        private final ParquetValueReader<?>[] readers;
        private final TripleIterator<?> column;
        private final List<TripleIterator<?>> children;

        protected StructReader(List<Type> types, List<ParquetValueReader<?>> readers) {
            this.readers = (ParquetValueReader[])Array.newInstance(ParquetValueReader.class, readers.size());
            TripleIterator[] columns = (TripleIterator[])Array.newInstance(TripleIterator.class, readers.size());
            Setter[] setters = (Setter[])Array.newInstance(Setter.class, readers.size());
            ImmutableList.Builder columnsBuilder = ImmutableList.builder();
            for (int i = 0; i < readers.size(); ++i) {
                ParquetValueReader<?> reader = readers.get(i);
                this.readers[i] = readers.get(i);
                columns[i] = reader.column();
                setters[i] = this.newSetter(reader, types.get(i));
                columnsBuilder.addAll(reader.columns());
            }
            this.children = columnsBuilder.build();
            this.column = this.firstNonNullColumn(this.children);
        }

        @Override
        public final void setPageSource(PageReadStore pageStore, long rowPosition) {
            for (ParquetValueReader<?> reader : this.readers) {
                reader.setPageSource(pageStore, rowPosition);
            }
        }

        @Override
        public final TripleIterator<?> column() {
            return this.column;
        }

        @Override
        public final T read(T reuse) {
            I intermediate = this.newStructData(reuse);
            for (int i = 0; i < this.readers.length; ++i) {
                this.set(intermediate, i, this.readers[i].read(this.get(intermediate, i)));
            }
            return this.buildStruct(intermediate);
        }

        @Override
        public List<TripleIterator<?>> columns() {
            return this.children;
        }

        private <E> Setter<I> newSetter(ParquetValueReader<E> reader, Type type) {
            if (reader instanceof UnboxedReader && type.isPrimitive()) {
                UnboxedReader unboxed = (UnboxedReader)reader;
                switch (type.asPrimitiveType().getPrimitiveTypeName()) {
                    case BOOLEAN: {
                        return (record, pos, ignored) -> this.setBoolean(record, pos, unboxed.readBoolean());
                    }
                    case INT32: {
                        return (record, pos, ignored) -> this.setInteger(record, pos, unboxed.readInteger());
                    }
                    case INT64: {
                        return (record, pos, ignored) -> this.setLong(record, pos, unboxed.readLong());
                    }
                    case FLOAT: {
                        return (record, pos, ignored) -> this.setFloat(record, pos, unboxed.readFloat());
                    }
                    case DOUBLE: {
                        return (record, pos, ignored) -> this.setDouble(record, pos, unboxed.readDouble());
                    }
                    case INT96: 
                    case FIXED_LEN_BYTE_ARRAY: 
                    case BINARY: {
                        return (record, pos, ignored) -> this.set(record, pos, unboxed.readBinary());
                    }
                }
                throw new UnsupportedOperationException("Unsupported type: " + type);
            }
            return (record, pos, reuse) -> {
                Object obj = reader.read(reuse);
                if (obj != null) {
                    this.set(record, pos, obj);
                } else {
                    this.setNull(record, pos);
                }
            };
        }

        private <E> E get(I intermediate, int pos) {
            return (E)this.getField(intermediate, pos);
        }

        protected abstract I newStructData(T var1);

        protected abstract Object getField(I var1, int var2);

        protected abstract T buildStruct(I var1);

        protected abstract void set(I var1, int var2, Object var3);

        protected void setNull(I struct, int pos) {
            this.set(struct, pos, null);
        }

        protected void setBoolean(I struct, int pos, boolean value) {
            this.set(struct, pos, value);
        }

        protected void setInteger(I struct, int pos, int value) {
            this.set(struct, pos, value);
        }

        protected void setLong(I struct, int pos, long value) {
            this.set(struct, pos, value);
        }

        protected void setFloat(I struct, int pos, float value) {
            this.set(struct, pos, Float.valueOf(value));
        }

        protected void setDouble(I struct, int pos, double value) {
            this.set(struct, pos, value);
        }

        private TripleIterator<?> firstNonNullColumn(List<TripleIterator<?>> columns) {
            for (TripleIterator<?> col : columns) {
                if (col == NullReader.NULL_COLUMN) continue;
                return col;
            }
            return NullReader.NULL_COLUMN;
        }

        private static interface Setter<R> {
            public void set(R var1, int var2, Object var3);
        }
    }

    public static class ReusableEntry<K, V>
    implements Map.Entry<K, V> {
        private K key = null;
        private V value = null;

        public void set(K newKey, V newValue) {
            this.key = newKey;
            this.value = newValue;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V lastValue = this.value;
            this.value = newValue;
            return lastValue;
        }
    }

    public static class MapReader<K, V>
    extends RepeatedKeyValueReader<Map<K, V>, Map<K, V>, K, V> {
        private final ReusableEntry<K, V> nullEntry = new ReusableEntry();
        private Map<K, V> lastMap = null;
        private Iterator<Map.Entry<K, V>> pairs = null;

        public MapReader(int definitionLevel, int repetitionLevel, ParquetValueReader<K> keyReader, ParquetValueReader<V> valueReader) {
            super(definitionLevel, repetitionLevel, keyReader, valueReader);
        }

        @Override
        protected Map<K, V> newMapData(Map<K, V> reuse) {
            Map map;
            if (this.lastMap != null) {
                this.lastMap.clear();
                map = this.lastMap;
            } else {
                map = Maps.newLinkedHashMap();
            }
            if (reuse != null) {
                this.lastMap = reuse;
                this.pairs = reuse.entrySet().iterator();
            } else {
                this.lastMap = null;
                this.pairs = Collections.emptyIterator();
            }
            return map;
        }

        @Override
        protected Map.Entry<K, V> getPair(Map<K, V> map) {
            if (this.pairs.hasNext()) {
                return this.pairs.next();
            }
            return this.nullEntry;
        }

        @Override
        protected void addPair(Map<K, V> map, K key, V value) {
            map.put(key, value);
        }

        @Override
        protected Map<K, V> buildMap(Map<K, V> map) {
            return map;
        }
    }

    public static abstract class RepeatedKeyValueReader<M, I, K, V>
    implements ParquetValueReader<M> {
        private final int definitionLevel;
        private final int repetitionLevel;
        private final ParquetValueReader<K> keyReader;
        private final ParquetValueReader<V> valueReader;
        private final TripleIterator<?> column;
        private final List<TripleIterator<?>> children;

        protected RepeatedKeyValueReader(int definitionLevel, int repetitionLevel, ParquetValueReader<K> keyReader, ParquetValueReader<V> valueReader) {
            this.definitionLevel = definitionLevel;
            this.repetitionLevel = repetitionLevel;
            this.keyReader = keyReader;
            this.valueReader = valueReader;
            this.column = keyReader.column();
            this.children = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(keyReader.columns())).addAll(valueReader.columns())).build();
        }

        @Override
        public void setPageSource(PageReadStore pageStore, long rowPosition) {
            this.keyReader.setPageSource(pageStore, rowPosition);
            this.valueReader.setPageSource(pageStore, rowPosition);
        }

        @Override
        public TripleIterator<?> column() {
            return this.column;
        }

        @Override
        public M read(M reuse) {
            I intermediate = this.newMapData(reuse);
            do {
                if (this.column.currentDefinitionLevel() > this.definitionLevel) {
                    Map.Entry<K, V> pair = this.getPair(intermediate);
                    this.addPair(intermediate, this.keyReader.read(pair.getKey()), this.valueReader.read(pair.getValue()));
                    continue;
                }
                for (TripleIterator<?> child : this.children) {
                    child.nextNull();
                }
                break;
            } while (this.column.currentRepetitionLevel() > this.repetitionLevel);
            return this.buildMap(intermediate);
        }

        @Override
        public List<TripleIterator<?>> columns() {
            return this.children;
        }

        protected abstract I newMapData(M var1);

        protected abstract Map.Entry<K, V> getPair(I var1);

        protected abstract void addPair(I var1, K var2, V var3);

        protected abstract M buildMap(I var1);
    }

    public static class ListReader<E>
    extends RepeatedReader<List<E>, List<E>, E> {
        private List<E> lastList = null;
        private Iterator<E> elements = null;

        public ListReader(int definitionLevel, int repetitionLevel, ParquetValueReader<E> reader) {
            super(definitionLevel, repetitionLevel, reader);
        }

        @Override
        protected List<E> newListData(List<E> reuse) {
            List list;
            if (this.lastList != null) {
                this.lastList.clear();
                list = this.lastList;
            } else {
                list = Lists.newArrayList();
            }
            if (reuse != null) {
                this.lastList = reuse;
                this.elements = reuse.iterator();
            } else {
                this.lastList = null;
                this.elements = Collections.emptyIterator();
            }
            return list;
        }

        @Override
        protected E getElement(List<E> reuse) {
            if (this.elements.hasNext()) {
                return this.elements.next();
            }
            return null;
        }

        @Override
        protected void addElement(List<E> list, E element) {
            list.add(element);
        }

        @Override
        protected List<E> buildList(List<E> list) {
            return list;
        }
    }

    public static abstract class RepeatedReader<T, I, E>
    implements ParquetValueReader<T> {
        private final int definitionLevel;
        private final int repetitionLevel;
        private final ParquetValueReader<E> reader;
        private final TripleIterator<?> column;
        private final List<TripleIterator<?>> children;

        protected RepeatedReader(int definitionLevel, int repetitionLevel, ParquetValueReader<E> reader) {
            this.definitionLevel = definitionLevel;
            this.repetitionLevel = repetitionLevel;
            this.reader = reader;
            this.column = reader.column();
            this.children = reader.columns();
        }

        @Override
        public void setPageSource(PageReadStore pageStore, long rowPosition) {
            this.reader.setPageSource(pageStore, rowPosition);
        }

        @Override
        public TripleIterator<?> column() {
            return this.column;
        }

        @Override
        public T read(T reuse) {
            I intermediate = this.newListData(reuse);
            do {
                if (this.column.currentDefinitionLevel() > this.definitionLevel) {
                    this.addElement(intermediate, this.reader.read(this.getElement(intermediate)));
                    continue;
                }
                for (TripleIterator<?> child : this.children) {
                    child.nextNull();
                }
                break;
            } while (this.column.currentRepetitionLevel() > this.repetitionLevel);
            return this.buildList(intermediate);
        }

        @Override
        public List<TripleIterator<?>> columns() {
            return this.children;
        }

        protected abstract I newListData(T var1);

        protected abstract E getElement(I var1);

        protected abstract void addElement(I var1, E var2);

        protected abstract T buildList(I var1);
    }

    private static class OptionReader<T>
    implements ParquetValueReader<T> {
        private final int definitionLevel;
        private final ParquetValueReader<T> reader;
        private final TripleIterator<?> column;
        private final List<TripleIterator<?>> children;

        OptionReader(int definitionLevel, ParquetValueReader<T> reader) {
            this.definitionLevel = definitionLevel;
            this.reader = reader;
            this.column = reader.column();
            this.children = reader.columns();
        }

        @Override
        public void setPageSource(PageReadStore pageStore, long rowPosition) {
            this.reader.setPageSource(pageStore, rowPosition);
        }

        @Override
        public TripleIterator<?> column() {
            return this.column;
        }

        @Override
        public T read(T reuse) {
            if (this.column.currentDefinitionLevel() > this.definitionLevel) {
                return this.reader.read(reuse);
            }
            for (TripleIterator<?> child : this.children) {
                child.nextNull();
            }
            return null;
        }

        @Override
        public List<TripleIterator<?>> columns() {
            return this.children;
        }
    }

    public static class ByteArrayReader
    extends PrimitiveReader<byte[]> {
        public ByteArrayReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public byte[] read(byte[] ignored) {
            return this.column.nextBinary().getBytes();
        }
    }

    public static class BytesReader
    extends PrimitiveReader<ByteBuffer> {
        public BytesReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public ByteBuffer read(ByteBuffer reuse) {
            Binary binary = this.column.nextBinary();
            ByteBuffer data = binary.toByteBuffer();
            if (reuse != null && reuse.hasArray() && reuse.capacity() >= data.remaining()) {
                data.get(reuse.array(), reuse.arrayOffset(), data.remaining());
                reuse.position(0);
                reuse.limit(binary.length());
                return reuse;
            }
            byte[] array = new byte[data.remaining()];
            data.get(array, 0, data.remaining());
            return ByteBuffer.wrap(array);
        }
    }

    public static class BinaryAsDecimalReader
    extends PrimitiveReader<BigDecimal> {
        private int scale;

        public BinaryAsDecimalReader(ColumnDescriptor desc, int scale) {
            super(desc);
            this.scale = scale;
        }

        @Override
        public BigDecimal read(BigDecimal reuse) {
            byte[] bytes = this.column.nextBinary().getBytesUnsafe();
            return new BigDecimal(new BigInteger(bytes), this.scale);
        }
    }

    public static class LongAsDecimalReader
    extends PrimitiveReader<BigDecimal> {
        private final int scale;

        public LongAsDecimalReader(ColumnDescriptor desc, int scale) {
            super(desc);
            this.scale = scale;
        }

        @Override
        public BigDecimal read(BigDecimal ignored) {
            return new BigDecimal(BigInteger.valueOf(this.column.nextLong()), this.scale);
        }
    }

    public static class IntegerAsDecimalReader
    extends PrimitiveReader<BigDecimal> {
        private final int scale;

        public IntegerAsDecimalReader(ColumnDescriptor desc, int scale) {
            super(desc);
            this.scale = scale;
        }

        @Override
        public BigDecimal read(BigDecimal ignored) {
            return new BigDecimal(BigInteger.valueOf(this.column.nextInteger()), this.scale);
        }
    }

    public static class FloatAsDoubleReader
    extends UnboxedReader<Double> {
        public FloatAsDoubleReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public Double read(Double ignored) {
            return this.readDouble();
        }

        @Override
        public double readDouble() {
            return super.readFloat();
        }
    }

    public static class IntAsLongReader
    extends UnboxedReader<Long> {
        public IntAsLongReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public Long read(Long ignored) {
            return this.readLong();
        }

        @Override
        public long readLong() {
            return super.readInteger();
        }
    }

    public static class StringReader
    extends PrimitiveReader<String> {
        public StringReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public String read(String reuse) {
            return this.column.nextBinary().toStringUsingUTF8();
        }
    }

    public static class UnboxedReader<T>
    extends PrimitiveReader<T> {
        public UnboxedReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public T read(T ignored) {
            return (T)this.column.next();
        }

        public boolean readBoolean() {
            return this.column.nextBoolean();
        }

        public int readInteger() {
            return this.column.nextInteger();
        }

        public long readLong() {
            return this.column.nextLong();
        }

        public float readFloat() {
            return this.column.nextFloat();
        }

        public double readDouble() {
            return this.column.nextDouble();
        }

        public Binary readBinary() {
            return this.column.nextBinary();
        }
    }

    public static abstract class PrimitiveReader<T>
    implements ParquetValueReader<T> {
        private final ColumnDescriptor desc;
        protected final ColumnIterator<?> column;
        private final List<TripleIterator<?>> children;

        protected PrimitiveReader(ColumnDescriptor desc) {
            this.desc = desc;
            this.column = ColumnIterator.newIterator(desc, "");
            this.children = ImmutableList.of(this.column);
        }

        @Override
        public void setPageSource(PageReadStore pageStore, long rowPosition) {
            this.column.setPageSource(pageStore.getPageReader(this.desc));
        }

        @Override
        public TripleIterator<?> column() {
            return this.column;
        }

        @Override
        public List<TripleIterator<?>> columns() {
            return this.children;
        }
    }

    static class PositionReader
    implements ParquetValueReader<Long> {
        private long rowOffset = -1L;
        private long rowGroupStart;

        PositionReader() {
        }

        @Override
        public Long read(Long reuse) {
            ++this.rowOffset;
            return this.rowGroupStart + this.rowOffset;
        }

        @Override
        public TripleIterator<?> column() {
            return NullReader.NULL_COLUMN;
        }

        @Override
        public List<TripleIterator<?>> columns() {
            return NullReader.COLUMNS;
        }

        @Override
        public void setPageSource(PageReadStore pageStore, long rowPosition) {
            this.rowGroupStart = rowPosition;
            this.rowOffset = -1L;
        }
    }

    static class ConstantReader<C>
    implements ParquetValueReader<C> {
        private final C constantValue;
        private final TripleIterator<?> column;
        private final List<TripleIterator<?>> children;

        ConstantReader(C constantValue) {
            this.constantValue = constantValue;
            this.column = NullReader.NULL_COLUMN;
            this.children = NullReader.COLUMNS;
        }

        ConstantReader(C constantValue, final int definitionLevel) {
            this.constantValue = constantValue;
            this.column = new TripleIterator<Object>(){

                @Override
                public int currentDefinitionLevel() {
                    return definitionLevel;
                }

                @Override
                public int currentRepetitionLevel() {
                    return 0;
                }

                @Override
                public <N> N nextNull() {
                    return null;
                }

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Object next() {
                    return null;
                }
            };
            this.children = ImmutableList.of(this.column);
        }

        @Override
        public C read(C reuse) {
            return this.constantValue;
        }

        @Override
        public TripleIterator<?> column() {
            return this.column;
        }

        @Override
        public List<TripleIterator<?>> columns() {
            return this.children;
        }

        @Override
        public void setPageSource(PageReadStore pageStore, long rowPosition) {
        }
    }

    private static class NullReader<T>
    implements ParquetValueReader<T> {
        private static final NullReader<Void> INSTANCE = new NullReader();
        private static final ImmutableList<TripleIterator<?>> COLUMNS = ImmutableList.of();
        private static final TripleIterator<?> NULL_COLUMN = new TripleIterator<Object>(){

            @Override
            public int currentDefinitionLevel() {
                return 0;
            }

            @Override
            public int currentRepetitionLevel() {
                return 0;
            }

            @Override
            public <N> N nextNull() {
                return null;
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Object next() {
                return null;
            }
        };

        private NullReader() {
        }

        @Override
        public T read(T reuse) {
            return null;
        }

        @Override
        public TripleIterator<?> column() {
            return NULL_COLUMN;
        }

        @Override
        public List<TripleIterator<?>> columns() {
            return COLUMNS;
        }

        @Override
        public void setPageSource(PageReadStore pageStore, long rowPosition) {
        }
    }
}

