/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RegisterTableRequest", generator="Immutables")
@Immutable
public final class ImmutableRegisterTableRequest
implements RegisterTableRequest {
    private final String name;
    private final String metadataLocation;

    private ImmutableRegisterTableRequest(String name, String metadataLocation) {
        this.name = name;
        this.metadataLocation = metadataLocation;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String metadataLocation() {
        return this.metadataLocation;
    }

    public final ImmutableRegisterTableRequest withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRegisterTableRequest(newValue, this.metadataLocation);
    }

    public final ImmutableRegisterTableRequest withMetadataLocation(String value) {
        String newValue = Objects.requireNonNull(value, "metadataLocation");
        if (this.metadataLocation.equals(newValue)) {
            return this;
        }
        return new ImmutableRegisterTableRequest(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRegisterTableRequest && this.equalTo(0, (ImmutableRegisterTableRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableRegisterTableRequest another) {
        return this.name.equals(another.name) && this.metadataLocation.equals(another.metadataLocation);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.metadataLocation.hashCode();
        return h2;
    }

    public String toString() {
        return "RegisterTableRequest{name=" + this.name + ", metadataLocation=" + this.metadataLocation + "}";
    }

    public static ImmutableRegisterTableRequest copyOf(RegisterTableRequest instance) {
        if (instance instanceof ImmutableRegisterTableRequest) {
            return (ImmutableRegisterTableRequest)instance;
        }
        return ImmutableRegisterTableRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RegisterTableRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_METADATA_LOCATION = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String metadataLocation;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RegisterTableRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.metadataLocation(instance.metadataLocation());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metadataLocation(String metadataLocation) {
            this.metadataLocation = Objects.requireNonNull(metadataLocation, "metadataLocation");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRegisterTableRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRegisterTableRequest(this.name, this.metadataLocation);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("metadataLocation");
            }
            return "Cannot build RegisterTableRequest, some of required attributes are not set " + attributes;
        }
    }
}

