/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.kerberos.KerberosConfig;
import org.apache.seatunnel.common.config.ConfigRuntimeException;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class CommonConfig
extends KerberosConfig
implements Serializable {
    private static final long serialVersionUID = 239821141534421580L;
    public static final Option<String> KEY_CATALOG_NAME = Options.key((String)"catalog_name").stringType().defaultValue((Object)"default").withDescription(" the iceberg catalog name");
    public static final Option<String> KEY_NAMESPACE = Options.key((String)"namespace").stringType().defaultValue((Object)"default").withDescription(" the iceberg namespace");
    public static final Option<String> KEY_TABLE = Options.key((String)"table").stringType().noDefaultValue().withDescription(" the iceberg table");
    public static final Option<Map<String, String>> CATALOG_PROPS = Options.key((String)"iceberg.catalog.config").mapType().noDefaultValue().withDescription("Specify the properties for initializing the Iceberg catalog, which can be referenced in this file:'https://github.com/apache/iceberg/blob/main/core/src/main/java/org/apache/iceberg/CatalogProperties.java'");
    public static final Option<Map<String, String>> HADOOP_PROPS = Options.key((String)"hadoop.config").mapType().defaultValue(new HashMap()).withDescription("Properties passed through to the Hadoop configuration");
    public static final Option<String> HADOOP_CONF_PATH_PROP = Options.key((String)"iceberg.hadoop-conf-path").stringType().defaultValue(null).withDescription("The specified loading paths for the 'core-site.xml', 'hdfs-site.xml', 'hive-site.xml' files.");
    public static final Option<Boolean> KEY_CASE_SENSITIVE = Options.key((String)"case_sensitive").booleanType().defaultValue((Object)false).withDescription(" the iceberg case_sensitive");
    private String catalogName;
    private String namespace;
    private String table;
    private boolean caseSensitive;
    private Map<String, String> catalogProps;
    private Map<String, String> hadoopProps;
    private String hadoopConfPath;
    private String kerberosPrincipal;
    private String kerberosKeytabPath;
    private String kerberosKrb5ConfPath;

    public CommonConfig(ReadonlyConfig pluginConfig) {
        this.catalogName = this.checkArgumentNotNull((String)pluginConfig.get(KEY_CATALOG_NAME));
        this.namespace = (String)pluginConfig.get(KEY_NAMESPACE);
        this.table = (String)pluginConfig.get(KEY_TABLE);
        this.catalogProps = (Map)pluginConfig.get(CATALOG_PROPS);
        this.hadoopProps = (Map)pluginConfig.get(HADOOP_PROPS);
        this.hadoopConfPath = (String)pluginConfig.get(HADOOP_CONF_PATH_PROP);
        if (pluginConfig.toConfig().hasPath(KEY_CASE_SENSITIVE.key())) {
            this.caseSensitive = (Boolean)pluginConfig.get(KEY_CASE_SENSITIVE);
        }
        if (pluginConfig.getOptional(KERBEROS_PRINCIPAL).isPresent()) {
            this.kerberosPrincipal = (String)pluginConfig.getOptional(KERBEROS_PRINCIPAL).get();
        }
        if (pluginConfig.getOptional(KRB5_PATH).isPresent()) {
            this.kerberosKrb5ConfPath = (String)pluginConfig.getOptional(KRB5_PATH).get();
        }
        if (pluginConfig.getOptional(KERBEROS_KEYTAB_PATH).isPresent()) {
            this.kerberosKeytabPath = (String)pluginConfig.getOptional(KERBEROS_KEYTAB_PATH).get();
        }
        this.validate();
    }

    protected <T> T checkArgumentNotNull(T argument) {
        Preconditions.checkNotNull(argument);
        return argument;
    }

    private void validate() {
        this.checkState(!this.catalogProps.isEmpty(), "Must specify iceberg catalog config");
    }

    private void checkState(boolean condition, String msg) {
        if (!condition) {
            throw new ConfigRuntimeException(msg);
        }
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTable() {
        return this.table;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public Map<String, String> getCatalogProps() {
        return this.catalogProps;
    }

    public Map<String, String> getHadoopProps() {
        return this.hadoopProps;
    }

    public String getHadoopConfPath() {
        return this.hadoopConfPath;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public String getKerberosKeytabPath() {
        return this.kerberosKeytabPath;
    }

    public String getKerberosKrb5ConfPath() {
        return this.kerberosKrb5ConfPath;
    }

    public String toString() {
        return "CommonConfig(catalogName=" + this.getCatalogName() + ", namespace=" + this.getNamespace() + ", table=" + this.getTable() + ", caseSensitive=" + this.isCaseSensitive() + ", catalogProps=" + this.getCatalogProps() + ", hadoopProps=" + this.getHadoopProps() + ", hadoopConfPath=" + this.getHadoopConfPath() + ", kerberosPrincipal=" + this.getKerberosPrincipal() + ", kerberosKeytabPath=" + this.getKerberosKeytabPath() + ", kerberosKrb5ConfPath=" + this.getKerberosKrb5ConfPath() + ")";
    }
}

