/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.sink.writer;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.BaseTaskWriter;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.UnpartitionedWriter;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.connectors.seatunnel.iceberg.IcebergTableLoader;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.SinkConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.writer.IcebergRecordWriter;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.writer.PartitionedAppendWriter;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.writer.PartitionedDeltaWriter;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.writer.RecordWriter;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.writer.UnpartitionedDeltaWriter;
import org.apache.seatunnel.connectors.seatunnel.iceberg.utils.SchemaUtils;
import org.apache.seatunnel.shade.com.google.common.collect.Maps;
import org.apache.seatunnel.shade.com.google.common.collect.Sets;
import org.apache.seatunnel.shade.com.google.common.primitives.Ints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergWriterFactory {
    private static final Logger log = LoggerFactory.getLogger(IcebergWriterFactory.class);
    private final IcebergTableLoader tableLoader;
    private final SinkConfig config;

    public IcebergWriterFactory(IcebergTableLoader tableLoader, SinkConfig config) {
        this.tableLoader = tableLoader;
        this.config = config;
    }

    public RecordWriter createWriter(TableSchema tableSchema) {
        Table table;
        try {
            table = this.tableLoader.loadTable();
        }
        catch (NoSuchTableException exception) {
            switch (this.config.getSchemaSaveMode()) {
                case CREATE_SCHEMA_WHEN_NOT_EXIST: {
                    table = SchemaUtils.autoCreateTable(this.tableLoader.getCatalog(), this.tableLoader.getTableIdentifier(), this.config, tableSchema);
                    if (this.config.getCommitBranch() == null) break;
                    table.manageSnapshots().createBranch(this.config.getCommitBranch()).commit();
                    break;
                }
                default: {
                    throw exception;
                }
            }
        }
        return new IcebergRecordWriter(table, this, this.config);
    }

    public TaskWriter<Record> createTaskWriter(Table table, SinkConfig config) {
        HashMap tableProps = Maps.newHashMap(table.properties());
        tableProps.putAll(config.getWriteProps());
        String formatStr = tableProps.getOrDefault("write.format.default", "parquet");
        FileFormat format = FileFormat.valueOf(formatStr.toUpperCase());
        long targetFileSize = PropertyUtil.propertyAsLong(tableProps, "write.target-file-size-bytes", 0x20000000L);
        Set<Integer> identifierFieldIds = table.schema().identifierFieldIds();
        List<String> idCols = config.getPrimaryKeys();
        if (!idCols.isEmpty()) {
            identifierFieldIds = idCols.stream().map(colName -> config.isCaseSensitive() ? table.schema().caseInsensitiveFindField((String)colName).fieldId() : table.schema().findField((String)colName).fieldId()).collect(Collectors.toSet());
        }
        GenericAppenderFactory appenderFactory = identifierFieldIds == null || identifierFieldIds.isEmpty() ? new GenericAppenderFactory(table.schema(), table.spec(), null, null, null).setAll(tableProps) : new GenericAppenderFactory(table.schema(), table.spec(), Ints.toArray(identifierFieldIds), TypeUtil.select(table.schema(), (Set<Integer>)Sets.newHashSet(identifierFieldIds)), null).setAll(tableProps);
        OutputFileFactory fileFactory = OutputFileFactory.builderFor(table, 1, System.currentTimeMillis()).defaultSpec(table.spec()).operationId(UUID.randomUUID().toString()).format(format).build();
        BaseTaskWriter writer = table.spec().isUnpartitioned() ? (identifierFieldIds.isEmpty() && !config.isUpsertModeEnabled() ? new UnpartitionedWriter<Record>(table.spec(), format, appenderFactory, fileFactory, table.io(), targetFileSize) : new UnpartitionedDeltaWriter(table.spec(), format, appenderFactory, fileFactory, table.io(), targetFileSize, table.schema(), identifierFieldIds, config.isUpsertModeEnabled())) : (identifierFieldIds.isEmpty() && !config.isUpsertModeEnabled() ? new PartitionedAppendWriter(table.spec(), format, appenderFactory, fileFactory, table.io(), targetFileSize, table.schema()) : new PartitionedDeltaWriter(table.spec(), format, appenderFactory, fileFactory, table.io(), targetFileSize, table.schema(), identifierFieldIds, config.isUpsertModeEnabled()));
        return writer;
    }
}

