/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.sink.writer;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.BaseTaskWriter;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.util.Tasks;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.writer.BaseDeltaTaskWriter;
import org.apache.seatunnel.connectors.seatunnel.iceberg.sink.writer.IcebergRecord;
import org.apache.seatunnel.shade.com.google.common.collect.Maps;

public class PartitionedDeltaWriter
extends BaseDeltaTaskWriter {
    private final PartitionKey partitionKey;
    private final Map<PartitionKey, BaseDeltaTaskWriter.RowDataDeltaWriter> writers = Maps.newHashMap();

    public PartitionedDeltaWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<Record> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize, Schema schema, Set<Integer> identifierFieldIds, boolean upsertMode) {
        super(spec, format, appenderFactory, fileFactory, io, targetFileSize, schema, identifierFieldIds, upsertMode);
        this.partitionKey = new PartitionKey(spec, schema);
    }

    @Override
    BaseDeltaTaskWriter.RowDataDeltaWriter route(IcebergRecord row) {
        this.partitionKey.partition(this.wrapper().wrap(row));
        BaseDeltaTaskWriter.RowDataDeltaWriter writer = this.writers.get(this.partitionKey);
        if (writer == null) {
            PartitionKey copiedKey = this.partitionKey.copy();
            writer = new BaseDeltaTaskWriter.RowDataDeltaWriter(copiedKey);
            this.writers.put(copiedKey, writer);
        }
        return writer;
    }

    @Override
    public void close() {
        try {
            Tasks.foreach(this.writers.values()).throwFailureWhenFinished().noRetry().run(BaseTaskWriter.BaseEqualityDeltaWriter::close, IOException.class);
            this.writers.clear();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close equality delta writer", e);
        }
    }
}

