/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.writer;

import java.io.IOException;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.OrcProto;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.TypeDescription;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.CryptoUtils;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.PositionRecorder;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.PositionedOutputStream;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.SerializationUtils;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.StreamName;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.writer.TreeWriterBase;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.writer.WriterContext;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.writer.WriterEncryptionVariant;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.ql.util.JavaDataModel;

public class DoubleTreeWriter
extends TreeWriterBase {
    private final PositionedOutputStream stream;
    private final SerializationUtils utils;

    public DoubleTreeWriter(TypeDescription schema, WriterEncryptionVariant encryption, WriterContext writer) throws IOException {
        super(schema, encryption, writer);
        this.stream = writer.createStream(new StreamName(this.id, OrcProto.Stream.Kind.DATA, encryption));
        this.utils = new SerializationUtils();
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        block6: {
            DoubleColumnVector vec;
            block5: {
                super.writeBatch(vector, offset, length);
                vec = (DoubleColumnVector)vector;
                if (!vector.isRepeating) break block5;
                if (!vector.noNulls && vector.isNull[0]) break block6;
                double value = vec.vector[0];
                this.indexStatistics.updateDouble(value);
                if (this.createBloomFilter) {
                    if (this.bloomFilter != null) {
                        this.bloomFilter.addDouble(value);
                    }
                    this.bloomFilterUtf8.addDouble(value);
                }
                for (int i = 0; i < length; ++i) {
                    this.utils.writeDouble(this.stream, value);
                }
                break block6;
            }
            for (int i = 0; i < length; ++i) {
                if (!vec.noNulls && vec.isNull[i + offset]) continue;
                double value = vec.vector[i + offset];
                this.utils.writeDouble(this.stream, value);
                this.indexStatistics.updateDouble(value);
                if (!this.createBloomFilter) continue;
                if (this.bloomFilter != null) {
                    this.bloomFilter.addDouble(value);
                }
                this.bloomFilterUtf8.addDouble(value);
            }
        }
    }

    @Override
    public void writeStripe(int requiredIndexEntries) throws IOException {
        super.writeStripe(requiredIndexEntries);
        this.stream.flush();
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    void recordPosition(PositionRecorder recorder) throws IOException {
        super.recordPosition(recorder);
        this.stream.getPosition(recorder);
    }

    @Override
    public long estimateMemory() {
        return super.estimateMemory() + this.stream.getBufferSize();
    }

    @Override
    public long getRawDataSize() {
        long num = this.fileStatistics.getNumberOfValues();
        return num * (long)JavaDataModel.get().primitive2();
    }

    @Override
    public void flushStreams() throws IOException {
        super.flushStreams();
        this.stream.flush();
    }

    @Override
    public void prepareStripe(int stripeId) {
        super.prepareStripe(stripeId);
        this.stream.changeIv(CryptoUtils.modifyIvForStripe(stripeId));
    }
}

