/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.writer;

import java.io.IOException;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.ColumnStatistics;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.DataMask;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.StripeStatistics;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.TypeDescription;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.TypeUtils;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.writer.TreeWriter;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.writer.TreeWriterBase;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.writer.WriterContext;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.writer.WriterEncryptionVariant;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;

public class EncryptionTreeWriter
implements TreeWriter {
    private final TreeWriter[] childrenWriters;
    private final DataMask[] masks;
    private final ColumnVector scratch;
    private final VectorizedRowBatch scratchBatch;

    EncryptionTreeWriter(TypeDescription schema, WriterEncryptionVariant encryption, WriterContext context) throws IOException {
        this.scratch = TypeUtils.createColumn(schema, TypeDescription.RowBatchVersion.USE_DECIMAL64, 1024);
        this.childrenWriters = new TreeWriterBase[2];
        this.masks = new DataMask[this.childrenWriters.length];
        this.scratchBatch = schema.getCategory() == TypeDescription.Category.STRUCT ? new VectorizedRowBatch(schema.getChildren().size(), 1024) : new VectorizedRowBatch(1, 1024);
        this.masks[0] = null;
        this.childrenWriters[0] = TreeWriter.Factory.createSubtree(schema, encryption, context);
        this.masks[1] = context.getUnencryptedMask(schema.getId());
        this.childrenWriters[1] = TreeWriter.Factory.createSubtree(schema, null, context);
    }

    @Override
    public void writeRootBatch(VectorizedRowBatch batch, int offset, int length) throws IOException {
        this.scratchBatch.ensureSize(offset + length);
        for (int alt = 0; alt < this.childrenWriters.length; ++alt) {
            if (this.masks[alt] != null) {
                for (int col = 0; col < this.scratchBatch.cols.length; ++col) {
                    this.masks[alt].maskData(batch.cols[col], this.scratchBatch.cols[col], offset, length);
                }
                this.childrenWriters[alt].writeRootBatch(this.scratchBatch, offset, length);
                continue;
            }
            this.childrenWriters[alt].writeRootBatch(batch, offset, length);
        }
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        this.scratch.ensureSize(length, false);
        for (int alt = 0; alt < this.childrenWriters.length; ++alt) {
            if (this.masks[alt] != null) {
                this.masks[alt].maskData(vector, this.scratch, offset, length);
                this.childrenWriters[alt].writeBatch(this.scratch, offset, length);
                continue;
            }
            this.childrenWriters[alt].writeBatch(vector, offset, length);
        }
    }

    @Override
    public void createRowIndexEntry() throws IOException {
        for (TreeWriter child : this.childrenWriters) {
            child.createRowIndexEntry();
        }
    }

    @Override
    public void flushStreams() throws IOException {
        for (TreeWriter child : this.childrenWriters) {
            child.flushStreams();
        }
    }

    @Override
    public void writeStripe(int requiredIndexEntries) throws IOException {
        for (TreeWriter child : this.childrenWriters) {
            child.writeStripe(requiredIndexEntries);
        }
    }

    @Override
    public void addStripeStatistics(StripeStatistics[] stripeStatistics) throws IOException {
        for (TreeWriter child : this.childrenWriters) {
            child.addStripeStatistics(stripeStatistics);
        }
    }

    @Override
    public long estimateMemory() {
        long result = 0L;
        for (TreeWriter writer : this.childrenWriters) {
            result += writer.estimateMemory();
        }
        return result;
    }

    @Override
    public long getRawDataSize() {
        return this.childrenWriters[0].getRawDataSize();
    }

    @Override
    public void prepareStripe(int stripeId) {
        for (TreeWriter writer : this.childrenWriters) {
            writer.prepareStripe(stripeId);
        }
    }

    @Override
    public void writeFileStatistics() throws IOException {
        for (TreeWriter child : this.childrenWriters) {
            child.writeFileStatistics();
        }
    }

    @Override
    public void getCurrentStatistics(ColumnStatistics[] output) {
        this.childrenWriters[0].getCurrentStatistics(output);
    }
}

