/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.writer;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.OrcProto;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.TypeDescription;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.CryptoUtils;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.IntegerWriter;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.PositionRecorder;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.SerializationUtils;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.StreamName;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.writer.TreeWriterBase;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.writer.WriterContext;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.impl.writer.WriterEncryptionVariant;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.orc.storage.ql.util.JavaDataModel;

public class TimestampTreeWriter
extends TreeWriterBase {
    public static final int MILLIS_PER_SECOND = 1000;
    public static final String BASE_TIMESTAMP_STRING = "2015-01-01 00:00:00";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final IntegerWriter seconds;
    private final IntegerWriter nanos;
    private final boolean isDirectV2;
    private final boolean alwaysUTC;
    private final TimeZone localTimezone;
    private final long epoch;
    private final boolean useProleptic;

    public TimestampTreeWriter(TypeDescription schema, WriterEncryptionVariant encryption, WriterContext writer, boolean instantType) throws IOException {
        super(schema, encryption, writer);
        this.isDirectV2 = this.isNewWriteFormat(writer);
        this.seconds = this.createIntegerWriter(writer.createStream(new StreamName(this.id, OrcProto.Stream.Kind.DATA, encryption)), true, this.isDirectV2, writer);
        this.nanos = this.createIntegerWriter(writer.createStream(new StreamName(this.id, OrcProto.Stream.Kind.SECONDARY, encryption)), false, this.isDirectV2, writer);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
        this.alwaysUTC = instantType || writer.getUseUTCTimestamp();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (this.alwaysUTC) {
                dateFormat.setTimeZone(UTC);
                this.localTimezone = null;
                this.epoch = dateFormat.parse(BASE_TIMESTAMP_STRING).getTime() / 1000L;
            } else {
                this.localTimezone = TimeZone.getDefault();
                dateFormat.setTimeZone(this.localTimezone);
                this.epoch = dateFormat.parse(BASE_TIMESTAMP_STRING).getTime() / 1000L;
            }
        }
        catch (ParseException e) {
            throw new IOException("Unable to create base timestamp tree writer", e);
        }
        this.useProleptic = writer.getProlepticGregorian();
    }

    @Override
    OrcProto.ColumnEncoding.Builder getEncoding() {
        OrcProto.ColumnEncoding.Builder result = super.getEncoding();
        result.setKind(this.isDirectV2 ? OrcProto.ColumnEncoding.Kind.DIRECT_V2 : OrcProto.ColumnEncoding.Kind.DIRECT);
        return result;
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        block8: {
            TimestampColumnVector vec;
            block7: {
                super.writeBatch(vector, offset, length);
                vec = (TimestampColumnVector)vector;
                vec.changeCalendar(this.useProleptic, true);
                if (!vector.isRepeating) break block7;
                if (!vector.noNulls && vector.isNull[0]) break block8;
                long secs = vec.time[0] / 1000L;
                int newNanos = vec.nanos[0];
                long millis = secs * 1000L + (long)(newNanos / 1000000);
                if (millis < 0L && newNanos > 999999) {
                    millis -= 1000L;
                }
                long utc = vec.isUTC() || this.alwaysUTC ? millis : SerializationUtils.convertToUtc(this.localTimezone, millis);
                this.indexStatistics.updateTimestamp(utc, newNanos % 1000000);
                if (this.createBloomFilter) {
                    if (this.bloomFilter != null) {
                        this.bloomFilter.addLong(millis);
                    }
                    this.bloomFilterUtf8.addLong(utc);
                }
                long nano = TimestampTreeWriter.formatNanos(vec.nanos[0]);
                for (int i = 0; i < length; ++i) {
                    this.seconds.write(secs - this.epoch);
                    this.nanos.write(nano);
                }
                break block8;
            }
            for (int i = 0; i < length; ++i) {
                if (!vec.noNulls && vec.isNull[i + offset]) continue;
                long secs = vec.time[i + offset] / 1000L;
                int newNanos = vec.nanos[i + offset];
                long millis = secs * 1000L + (long)(newNanos / 1000000);
                if (millis < 0L && newNanos > 999999) {
                    millis -= 1000L;
                }
                long utc = vec.isUTC() || this.alwaysUTC ? millis : SerializationUtils.convertToUtc(this.localTimezone, millis);
                this.seconds.write(secs - this.epoch);
                this.nanos.write(TimestampTreeWriter.formatNanos(newNanos));
                this.indexStatistics.updateTimestamp(utc, newNanos % 1000000);
                if (!this.createBloomFilter) continue;
                if (this.bloomFilter != null) {
                    this.bloomFilter.addLong(millis);
                }
                this.bloomFilterUtf8.addLong(utc);
            }
        }
    }

    @Override
    public void writeStripe(int requiredIndexEntries) throws IOException {
        super.writeStripe(requiredIndexEntries);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    static long formatNanos(int nanos) {
        int trailingZeros;
        if (nanos == 0) {
            return 0L;
        }
        if (nanos % 100 != 0) {
            return (long)nanos << 3;
        }
        nanos /= 100;
        for (trailingZeros = 1; nanos % 10 == 0 && trailingZeros < 7; ++trailingZeros) {
            nanos /= 10;
        }
        return (long)nanos << 3 | (long)trailingZeros;
    }

    @Override
    void recordPosition(PositionRecorder recorder) throws IOException {
        super.recordPosition(recorder);
        this.seconds.getPosition(recorder);
        this.nanos.getPosition(recorder);
    }

    @Override
    public long estimateMemory() {
        return super.estimateMemory() + this.seconds.estimateMemory() + this.nanos.estimateMemory();
    }

    @Override
    public long getRawDataSize() {
        return this.fileStatistics.getNumberOfValues() * (long)JavaDataModel.get().lengthOfTimestamp();
    }

    @Override
    public void flushStreams() throws IOException {
        super.flushStreams();
        this.seconds.flush();
        this.nanos.flush();
    }

    @Override
    public void prepareStripe(int stripeId) {
        super.prepareStripe(stripeId);
        Consumer<byte[]> updater = CryptoUtils.modifyIvForStripe(stripeId);
        this.seconds.changeIv(updater);
        this.nanos.changeIv(updater);
    }
}

